/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.statement.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.invoice.statement.local.entity.InvoiceStatement;
import com.biz.crm.kms.business.invoice.statement.local.service.InvoiceStatementImportsService;
import com.biz.crm.kms.business.invoice.statement.local.service.internal.InvoiceStatementServiceImpl;
import com.biz.crm.kms.business.invoice.statement.sdk.dto.InvoiceStatementDto;
import com.biz.crm.kms.business.invoice.statement.sdk.dto.InvoiceStatementLogEventDto;
import com.biz.crm.kms.business.invoice.statement.sdk.event.InvoiceStatementLogEventListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class InvoiceStatementImportsServiceImpl
implements InvoiceStatementImportsService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceStatementImportsServiceImpl.class);
    @Autowired
    private InvoiceStatementServiceImpl invoiceStatementService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importsCreate(List<InvoiceStatement> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(aa -> {
            aa.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            aa.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            aa.setTenantCode(TenantUtils.getTenantCode());
            aa.setInvoicesSource("\u5bfc\u5165");
            this.invoiceStatementService.create((InvoiceStatement)((Object)aa));
        });
        Collection invoiceStatementDtos = this.nebulaToolkitService.copyCollectionByWhiteList(list, InvoiceStatement.class, InvoiceStatementDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        invoiceStatementDtos.forEach(dto -> {
            InvoiceStatementLogEventDto logEventDto = new InvoiceStatementLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer & Serializable onCreate = InvoiceStatementLogEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, InvoiceStatementLogEventListener.class, (SerializableBiConsumer)onCreate);
        });
    }
}

