/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.statement.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.invoice.acceptance.sdk.constant.AcceptanceOrderConstant;
import com.biz.crm.kms.business.invoice.acceptance.sdk.service.InvoiceAcceptanceVoService;
import com.biz.crm.kms.business.invoice.acceptance.sdk.vo.InvoiceAcceptanceVo;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.service.InvoiceExpenseSheetVoService;
import com.biz.crm.kms.business.invoice.returns.order.sdk.service.ReturnOrderVoService;
import com.biz.crm.kms.business.invoice.sdk.enums.InvoicesStatus;
import com.biz.crm.kms.business.invoice.statement.local.entity.InvoiceStatement;
import com.biz.crm.kms.business.invoice.statement.local.entity.InvoiceStatementAccptance;
import com.biz.crm.kms.business.invoice.statement.local.entity.InvoiceStatementDeduction;
import com.biz.crm.kms.business.invoice.statement.local.entity.InvoiceStatementReturnOrderDetail;
import com.biz.crm.kms.business.invoice.statement.local.entity.StatementDocumentRelation;
import com.biz.crm.kms.business.invoice.statement.local.repository.InvoiceStatementAccptanceRepository;
import com.biz.crm.kms.business.invoice.statement.local.repository.InvoiceStatementDeductionRepository;
import com.biz.crm.kms.business.invoice.statement.local.repository.InvoiceStatementDetailRepository;
import com.biz.crm.kms.business.invoice.statement.local.repository.InvoiceStatementGrabRepository;
import com.biz.crm.kms.business.invoice.statement.local.repository.InvoiceStatementRepository;
import com.biz.crm.kms.business.invoice.statement.local.repository.StatementDocumentRelationRepository;
import com.biz.crm.kms.business.invoice.statement.local.service.InvoiceStatementService;
import com.biz.crm.kms.business.invoice.statement.sdk.enums.DocumentType;
import com.biz.crm.kms.business.invoice.statement.sdk.enums.ExistStatus;
import com.biz.crm.kms.business.invoice.statement.sdk.vo.InvoiceExpenseSheetVo;
import com.biz.crm.kms.business.invoice.statement.sdk.vo.InvoiceReturnOrderVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="invoiceStatementService")
public class InvoiceStatementServiceImpl
implements InvoiceStatementService {
    @Autowired
    private InvoiceStatementRepository invoiceStatementRepository;
    @Autowired
    private DictDataVoService dictDataVoService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private StatementDocumentRelationRepository statementDocumentRelationRepository;
    @Autowired
    private InvoiceStatementGrabRepository invoiceStatementGrabRepository;
    @Autowired(required=false)
    private InvoiceStatementAccptanceRepository accptanceRepository;
    @Autowired(required=false)
    private InvoiceStatementDeductionRepository expenseRepository;
    @Autowired(required=false)
    private InvoiceStatementDetailRepository returnOrderRepository;
    @Autowired(required=false)
    private InvoiceAcceptanceVoService invoiceAcceptanceVoService;
    @Autowired(required=false)
    private ReturnOrderVoService returnOrderVoService;
    @Autowired(required=false)
    private InvoiceExpenseSheetVoService invoiceExpenseSheetVoService;

    @Override
    public InvoiceStatement findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        InvoiceStatement entity = (InvoiceStatement)((Object)this.invoiceStatementRepository.getById((Serializable)((Object)id)));
        return entity;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public InvoiceStatement create(InvoiceStatement invoiceStatement) {
        this.createValidate(invoiceStatement);
        invoiceStatement.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        invoiceStatement.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        invoiceStatement.setTenantCode(TenantUtils.getTenantCode());
        invoiceStatement.setOrderStatus(InvoicesStatus.S600.getDictCode());
        invoiceStatement.setOrderStatusMsg("\u8be5\u7ed3\u7b97\u5355\u4e3a\u624b\u52a8\u65b0\u589e");
        this.invoiceStatementRepository.saveOrUpdate((Object)invoiceStatement);
        this.saveOrders(invoiceStatement);
        return invoiceStatement;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public InvoiceStatement update(InvoiceStatement invoiceStatement) {
        this.updateValidate(invoiceStatement);
        invoiceStatement.setOrderStatus(InvoicesStatus.S600.getDictCode());
        invoiceStatement.setOrderStatusMsg("\u8be5\u7ed3\u7b97\u5355\u7ecf\u8fc7\u7f16\u8f91");
        invoiceStatement.setVersionNumber(1);
        this.invoiceStatementRepository.saveOrUpdate((Object)invoiceStatement);
        this.saveOrders(invoiceStatement);
        return invoiceStatement;
    }

    private void saveOrders(InvoiceStatement invoiceStatement) {
        if (!CollectionUtils.isEmpty(invoiceStatement.getAccptanceList())) {
            invoiceStatement.getAccptanceList().stream().map(accptance -> {
                accptance.setId(null);
                accptance.setStatementCode(invoiceStatement.getStatementCode());
                accptance.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
                accptance.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                accptance.setTenantCode(TenantUtils.getTenantCode());
                accptance.setRemark(ExistStatus.NEW.getCode());
                accptance.setVersionNumber(invoiceStatement.getVersionNumber());
                return accptance;
            }).collect(Collectors.toList());
            this.invoiceAcceptanceVoService.match(invoiceStatement.getAccptanceList().stream().map(InvoiceStatementAccptance::getDocumentCode).collect(Collectors.toList()), invoiceStatement.getStatementCode());
            this.accptanceRepository.saveBatch(invoiceStatement.getAccptanceList());
        }
        if (!CollectionUtils.isEmpty(invoiceStatement.getDeductionList())) {
            invoiceStatement.getDeductionList().stream().map(expenseOrder -> {
                expenseOrder.setId(null);
                expenseOrder.setStatementCode(invoiceStatement.getStatementCode());
                expenseOrder.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
                expenseOrder.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                expenseOrder.setTenantCode(TenantUtils.getTenantCode());
                expenseOrder.setRemark(ExistStatus.NEW.getCode());
                expenseOrder.setVersionNumber(invoiceStatement.getVersionNumber());
                return expenseOrder;
            }).collect(Collectors.toList());
            this.invoiceExpenseSheetVoService.match(invoiceStatement.getDeductionList().stream().map(InvoiceStatementDeduction::getDocumentCode).collect(Collectors.toList()), invoiceStatement.getStatementCode());
            this.expenseRepository.saveBatch(invoiceStatement.getDeductionList());
        }
        if (!CollectionUtils.isEmpty(invoiceStatement.getReturnOrderDetails())) {
            invoiceStatement.getReturnOrderDetails().stream().map(returnOrder -> {
                returnOrder.setId(null);
                returnOrder.setStatementCode(invoiceStatement.getStatementCode());
                returnOrder.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
                returnOrder.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                returnOrder.setTenantCode(TenantUtils.getTenantCode());
                returnOrder.setRemark(ExistStatus.NEW.getCode());
                returnOrder.setVersionNumber(invoiceStatement.getVersionNumber());
                return returnOrder;
            }).collect(Collectors.toList());
            this.returnOrderVoService.match(invoiceStatement.getAccptanceList().stream().map(InvoiceStatementAccptance::getDocumentCode).collect(Collectors.toList()), invoiceStatement.getStatementCode());
            this.returnOrderRepository.saveBatch(invoiceStatement.getReturnOrderDetails());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.invoiceStatementRepository.removeByIds(idList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.invoiceStatementRepository.updateEnableStatusByIds(idList, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.invoiceStatementRepository.updateEnableStatusByIds(idList, EnableStatusEnum.DISABLE);
    }

    @Override
    public InvoiceStatement findByStatementCode(String statementCode) {
        if (StringUtils.isBlank((CharSequence)statementCode)) {
            return null;
        }
        InvoiceStatement entity = this.invoiceStatementRepository.findByStatementCode(statementCode);
        if (ObjectUtils.isEmpty((Object)((Object)entity))) {
            return null;
        }
        ArrayList<InvoiceStatementAccptance> accptanceList = new ArrayList<InvoiceStatementAccptance>();
        ArrayList<InvoiceStatementReturnOrderDetail> returnOrderDetails = new ArrayList<InvoiceStatementReturnOrderDetail>();
        ArrayList<InvoiceStatementDeduction> deductionList = new ArrayList<InvoiceStatementDeduction>();
        List<StatementDocumentRelation> statementDocumentRelationList = this.statementDocumentRelationRepository.findByStatement(statementCode);
        if (statementDocumentRelationList != null) {
            statementDocumentRelationList.forEach(statementDocumentRelation -> {
                if (DocumentType.ACCEPTION.getCode().equals(statementDocumentRelation.getDocumentType())) {
                    InvoiceStatementAccptance accptance = new InvoiceStatementAccptance();
                    com.biz.crm.kms.business.invoice.statement.sdk.vo.InvoiceAcceptanceVo acceptanceVo = this.invoiceStatementGrabRepository.findByAccptanceCode(statementDocumentRelation.getDocumentCode());
                    if (acceptanceVo != null) {
                        InvoiceStatementAccptance accptanceEntity = (InvoiceStatementAccptance)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)acceptanceVo, InvoiceStatementAccptance.class, HashSet.class, ArrayList.class, new String[0])));
                        accptanceList.add(accptanceEntity);
                    } else {
                        accptance.setDocumentCode(statementDocumentRelation.getDocumentCode());
                        accptanceList.add(accptance);
                    }
                } else if (DocumentType.RETURN.getCode().equals(statementDocumentRelation.getDocumentType())) {
                    InvoiceStatementReturnOrderDetail returnOrderDetail = new InvoiceStatementReturnOrderDetail();
                    InvoiceReturnOrderVo returnOrderVo = this.invoiceStatementGrabRepository.findByReturnOrderCode(statementDocumentRelation.getDocumentCode());
                    if (returnOrderVo != null) {
                        InvoiceStatementReturnOrderDetail accptanceEntity = (InvoiceStatementReturnOrderDetail)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)returnOrderVo, InvoiceStatementReturnOrderDetail.class, HashSet.class, ArrayList.class, new String[0])));
                        returnOrderDetails.add(accptanceEntity);
                    } else {
                        returnOrderDetail.setDocumentCode(statementDocumentRelation.getDocumentCode());
                        returnOrderDetails.add(returnOrderDetail);
                    }
                } else if (DocumentType.EXPENSE.getCode().equals(statementDocumentRelation.getDocumentType())) {
                    InvoiceStatementDeduction deduction = new InvoiceStatementDeduction();
                    InvoiceExpenseSheetVo expenseSheetVo = this.invoiceStatementGrabRepository.findByExpenseSheetCode(statementDocumentRelation.getDocumentCode());
                    if (expenseSheetVo != null) {
                        InvoiceStatementDeduction accptanceEntity = (InvoiceStatementDeduction)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)expenseSheetVo, InvoiceStatementDeduction.class, HashSet.class, ArrayList.class, new String[0])));
                        deductionList.add(accptanceEntity);
                    } else {
                        deduction.setDocumentCode(statementDocumentRelation.getDocumentCode());
                        deductionList.add(deduction);
                    }
                }
            });
        }
        entity.setAccptanceList(accptanceList);
        entity.setReturnOrderDetails(returnOrderDetails);
        entity.setDeductionList(deductionList);
        return entity;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncStatementCode() {
        List<String> accOrderNumberCode = this.accptanceRepository.findKaOrderNumberCode();
        this.syncStatementCodeByAccOrderCode(accOrderNumberCode);
        List<String> returnOrderNumberCode = this.returnOrderRepository.findKaOrderNumberCode();
        this.syncStatementCodeByReturnOrderCode(returnOrderNumberCode);
        List<String> expenseSheetOrderCode = this.expenseRepository.findKaOrderNumberCode();
        this.syncStatementCodeByExpenseShOrderCode(expenseSheetOrderCode);
        List directGx = this.dictDataVoService.findByDictTypeCode("direct_gx");
        if (CollectionUtils.isEmpty((Collection)directGx)) {
            return;
        }
        List directCodes = directGx.stream().map(DictDataVo::getDictCode).distinct().collect(Collectors.toList());
        PageRequest pageable = PageRequest.of((int)1, (int)AcceptanceOrderConstant.ACCEPTANCE_ORDER_PAGE_SIZE);
        Page acceptanceVoPage = this.invoiceAcceptanceVoService.findByDirectCodes((Pageable)pageable, TenantUtils.getTenantCode(), directCodes);
        List<Object> acceptanceVoList = new ArrayList();
        acceptanceVoList.addAll(acceptanceVoPage.getRecords());
        while (acceptanceVoPage.hasNext() && AcceptanceOrderConstant.ACCEPTANCE_ORDER_LOOP_MAX >= pageable.getPageNumber()) {
            pageable = pageable.next();
            acceptanceVoPage = this.invoiceAcceptanceVoService.findByDirectCodes((Pageable)pageable, TenantUtils.getTenantCode(), directCodes);
            acceptanceVoList.addAll(acceptanceVoPage.getRecords());
        }
        acceptanceVoList = acceptanceVoList.stream().distinct().collect(Collectors.toList());
        List<String> relationKaCode = acceptanceVoList.stream().map(InvoiceAcceptanceVo::getRelateKaOrderNumber).collect(Collectors.toList());
        List<InvoiceStatementAccptance> gxAcceptanceList = this.accptanceRepository.findByOrderCode(relationKaCode);
        this.syncGxAcceptanceCodeByAccOrderCode(acceptanceVoList, gxAcceptanceList);
    }

    private void syncGxAcceptanceCodeByAccOrderCode(List<InvoiceAcceptanceVo> acceptanceVoList, List<InvoiceStatementAccptance> gxAcceptanceList) {
        Map invoiceAcceptanceVoMap = acceptanceVoList.stream().collect(Collectors.toMap(vo -> StringUtils.joinWith((String)"-", (Object[])new Object[]{vo.getRelateKaOrderNumber(), vo.getDeliveryPartyCode()}), Function.identity(), (a, b) -> a));
        ArrayList updateList = new ArrayList();
        gxAcceptanceList.forEach(x -> {
            String key = StringUtils.joinWith((String)"-", (Object[])new Object[]{x.getDocumentCode(), x.getTerminalCode()});
            InvoiceAcceptanceVo invoiceAcceptanceVo = (InvoiceAcceptanceVo)invoiceAcceptanceVoMap.get(key);
            if (Objects.nonNull(invoiceAcceptanceVo)) {
                invoiceAcceptanceVo.setStatementCode(x.getStatementCode());
                updateList.add(invoiceAcceptanceVo);
            }
        });
        if (!CollectionUtils.isEmpty(updateList)) {
            updateList.forEach(x -> this.accptanceRepository.updateStatementCodeGx(x.getId(), x.getStatementCode()));
        }
    }

    private void syncStatementCodeByExpenseShOrderCode(List<String> orderCode) {
        Map<String, String> codeMap;
        List<InvoiceStatementDeduction> returnOrderDetailList = this.expenseRepository.findByOrderCode(orderCode);
        if (!CollectionUtils.isEmpty(returnOrderDetailList) && MapUtils.isNotEmpty(codeMap = returnOrderDetailList.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getStatementCode())).collect(Collectors.toMap(InvoiceStatementDeduction::getDocumentCode, InvoiceStatementDeduction::getStatementCode, (a, b) -> a)))) {
            codeMap.forEach((k, v) -> this.expenseRepository.updateStatementCodeByOrderCode((String)k, (String)v));
        }
    }

    private void syncStatementCodeByReturnOrderCode(List<String> orderCode) {
        Map<String, String> codeMap;
        List<InvoiceStatementReturnOrderDetail> returnOrderDetailList = this.returnOrderRepository.findByOrderCode(orderCode);
        if (!CollectionUtils.isEmpty(returnOrderDetailList) && MapUtils.isNotEmpty(codeMap = returnOrderDetailList.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getStatementCode())).collect(Collectors.toMap(InvoiceStatementReturnOrderDetail::getDocumentCode, InvoiceStatementReturnOrderDetail::getStatementCode, (a, b) -> a)))) {
            codeMap.forEach((k, v) -> this.returnOrderRepository.updateStatementCodeByOrderCode((String)k, (String)v));
        }
    }

    private void syncStatementCodeByAccOrderCode(List<String> orderCode) {
        Map<String, String> codeMap;
        List<InvoiceStatementAccptance> accptanceList = this.accptanceRepository.findByOrderCode(orderCode);
        if (!CollectionUtils.isEmpty(accptanceList) && MapUtils.isNotEmpty(codeMap = accptanceList.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getStatementCode())).collect(Collectors.toMap(InvoiceStatementAccptance::getDocumentCode, InvoiceStatementAccptance::getStatementCode, (a, b) -> a)))) {
            codeMap.forEach((k, v) -> this.accptanceRepository.updateStatementCodeByOrderCode((String)k, (String)v));
        }
    }

    private void createValidate(InvoiceStatement invoiceStatement) {
        Validate.notNull((Object)((Object)invoiceStatement), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)invoiceStatement.getStatementCode(), (String)"\u7ed3\u7b97\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)invoiceStatement.getSoldToPartyCode(), (String)"\u552e\u8fbe\u65b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)invoiceStatement.getSoldToPartyName(), (String)"\u552e\u8fbe\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        InvoiceStatement entity = this.invoiceStatementRepository.finBystatementCode(invoiceStatement.getStatementCode(), TenantUtils.getTenantCode());
        Validate.isTrue((entity == null ? 1 : 0) != 0, (String)"\u8be5\u9a8c\u6536\u5355\u5df2\u5b58\u5728", (Object[])new Object[0]);
        invoiceStatement.setId(null);
    }

    private void updateValidate(InvoiceStatement invoiceStatement) {
        Validate.notNull((Object)((Object)invoiceStatement), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)invoiceStatement.getStatementCode()), (String)"\u7ed3\u7b97\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)invoiceStatement.getSoldToPartyCode(), (String)"\u552e\u8fbe\u65b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)invoiceStatement.getSoldToPartyName(), (String)"\u552e\u8fbe\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        InvoiceStatement entity = this.invoiceStatementRepository.findById(invoiceStatement.getId());
        Validate.isTrue((!ObjectUtils.notEqual((Object)entity.getStatementCode(), (Object)invoiceStatement.getStatementCode()) ? 1 : 0) != 0, (String)"\u7ed3\u7b97\u5355\u53f7\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
    }
}

