/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.statement.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.kms.business.invoice.statement.local.entity.InvoiceStatement;
import com.biz.crm.kms.business.invoice.statement.local.repository.InvoiceStatementDeductionRepository;
import com.biz.crm.kms.business.invoice.statement.local.repository.InvoiceStatementGrabRepository;
import com.biz.crm.kms.business.invoice.statement.local.repository.InvoiceStatementRepository;
import com.biz.crm.kms.business.invoice.statement.local.repository.StatementDocumentRelationRepository;
import com.biz.crm.kms.business.invoice.statement.local.service.InvoiceStatementGrabService;
import com.biz.crm.kms.business.invoice.statement.sdk.dto.InvoiceStatementDeductionDto;
import com.biz.crm.kms.business.invoice.statement.sdk.dto.InvoiceStatementDto;
import com.biz.crm.kms.business.invoice.statement.sdk.enums.DocumentType;
import com.biz.crm.kms.business.invoice.statement.sdk.enums.InvoiceStatementStatus;
import com.biz.crm.kms.business.invoice.statement.sdk.service.InvoiceStatementVoService;
import com.biz.crm.kms.business.invoice.statement.sdk.vo.InvoiceAcceptanceVo;
import com.biz.crm.kms.business.invoice.statement.sdk.vo.InvoiceExpenseSheetVo;
import com.biz.crm.kms.business.invoice.statement.sdk.vo.InvoiceReturnOrderVo;
import com.biz.crm.kms.business.invoice.statement.sdk.vo.InvoiceStatementDataVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class InvoiceStatementVoServiceImpl
implements InvoiceStatementVoService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceStatementVoServiceImpl.class);
    @Autowired
    private InvoiceStatementRepository invoiceStatementRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private InvoiceStatementGrabRepository invoiceStatementGrabRepository;
    @Autowired
    private StatementDocumentRelationRepository statementDocumentRelationRepository;
    @Autowired
    private InvoiceStatementGrabService invoiceStatementGrabService;
    @Autowired
    private InvoiceStatementDeductionRepository invoiceStatementDeductionRepository;

    public void manualSwitch(List<String> rawDateIds) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(rawDateIds)) {
            log.warn("\u672a\u63a5\u6536\u5230\u9700\u8f6c\u6362\u7ed3\u7b97\u5355ID\uff01");
            return;
        }
        List<InvoiceStatement> entities = this.invoiceStatementRepository.findByIds(rawDateIds);
        Validate.isTrue((!CollectionUtils.isEmpty(entities) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5", (Object[])new Object[0]);
        Validate.isTrue((!ObjectUtils.notEqual((Object)entities.size(), (Object)rawDateIds.size()) ? 1 : 0) != 0, (String)"\u6570\u636e\u8f6c\u6362\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        entities.forEach(entity -> Validate.isTrue((boolean)Lists.newArrayList((Object[])new String[]{InvoiceStatementStatus.S200.getDictCode(), InvoiceStatementStatus.S101.getDictCode(), InvoiceStatementStatus.S100.getDictCode()}).contains(entity.getOrderStatus()), (String)String.format("\u7ed3\u7b97\u5355[%s]\u5df2\u786e\u8ba4,\u65e0\u6cd5\u7ee7\u7eed\u5339\u914d", entity.getStatementCode()), (Object[])new Object[0]));
        List<String> orderNumbers = entities.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getStatementCode())).map(InvoiceStatement::getStatementCode).distinct().collect(Collectors.toList());
        this.invoiceStatementGrabService.filterSwitchIngOrderNumberList(orderNumbers);
        log.info("===== \u7ed3\u7b97\u5355\u624b\u52a8\u8f6c\u6362\u5f00\u59cb ======");
        this.invoiceStatementGrabService.manualSwitch(orderNumbers);
        log.info("===== \u7ed3\u7b97\u5355\u624b\u52a8\u8f6c\u6362\u5b8c\u6210 ======");
    }

    public List<InvoiceStatementDto> findInvoiceStatement(InvoiceStatementDto statementDto) {
        List<InvoiceStatement> invoiceStatementList = this.invoiceStatementRepository.findInvoiceStatement(statementDto);
        List invoiceStatementDtos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(invoiceStatementList, InvoiceStatement.class, InvoiceStatementDto.class, HashSet.class, ArrayList.class, new String[0]);
        return invoiceStatementDtos;
    }

    public Page<InvoiceStatementDto> findInvoiceStatementPaging(Pageable pageable, InvoiceStatementDto dto) {
        if (Objects.isNull(dto)) {
            dto = new InvoiceStatementDto();
        }
        return this.invoiceStatementRepository.findInvoiceStatementPaging(pageable, dto);
    }

    public Page<InvoiceAcceptanceVo> findNotMatchAccptance(Pageable pageable, InvoiceAcceptanceVo dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new InvoiceAcceptanceVo();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return this.invoiceStatementGrabRepository.findNotMatchAccptance(pageable, dto);
    }

    public Page<InvoiceReturnOrderVo> findNotMatchReturn(Pageable pageable, InvoiceReturnOrderVo dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new InvoiceReturnOrderVo();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return this.invoiceStatementGrabRepository.findNotMatchReturn(pageable, dto);
    }

    public Page<InvoiceExpenseSheetVo> findNotMatchExpense(Pageable pageable, InvoiceExpenseSheetVo dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new InvoiceExpenseSheetVo();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return this.invoiceStatementGrabRepository.findNotMatchExpense(pageable, dto);
    }

    public List<InvoiceStatementDataVo> findAllByConditions(String businessUnitCode, String beginDateStr, String endDateStr) {
        return this.invoiceStatementRepository.findAllByConditions(businessUnitCode, beginDateStr, endDateStr);
    }

    public List<InvoiceStatementDataVo> findAllByConditions(String date, String businessUnitCode) {
        return this.invoiceStatementRepository.findAllByConditions(date, businessUnitCode);
    }

    public InvoiceStatementDataVo findByStatementCode(String statementCode) {
        return this.invoiceStatementRepository.findByCode(statementCode, DocumentType.ACCEPTION.getCode());
    }

    public Page<InvoiceStatementDeductionDto> findKmsStatementExpensePage(Pageable pageable, InvoiceStatementDeductionDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new InvoiceStatementDeductionDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return this.invoiceStatementDeductionRepository.findKmsStatementExpensePage(pageable, dto);
    }
}

