package com.biz.crm.kms.business.invoice.statement.sdk.constant;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

/**
 * 结算单常量类
 *
 * @author ning.zhang
 * @date 2022/11/3
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class InvoiceStatementConstant {

  /**
   * KMS单据验收单 MQ topic
   */
  public static final String KMS_STATEMENT_TOPIC = "KMS_STATEMENT_TOPIC";

  /**
   * 结算单redis锁定时间
   * */
  public static final Integer STATEMENT_REDIS_TIME = 1800;

  /**
   * 结算单自动转换 分页size
   */
  public static final Integer STATEMENT_PAGE_SIZE = 800;

  /**
   * 结算单自动转换 分页后最大循环次数  和 上个参数配合使用
   * 自动转换单词最大自动转换数量为   {@link STATEMENT_PAGE_SIZE }*{@link STATEMENT_LOOP_MAX }
   */
  public static final Integer STATEMENT_LOOP_MAX = 1000;

  /**
   * 结算单消息tag
   * */
  public static final String STATEMENT_MESSAGE_TAG = "KMS_STATEMENT_MESSAGE_TAG";

  /**
   * 结算单redis锁前缀
   * */
  public static final String STATEMENT_CONVERT_LOCK = "KMS:STATEMENT:CONVERT:LOCK";


  /**
   * 结算单自动转换redis锁前缀
   * */
  public static final String STATEMENT_AUTO_NOT_CONVERT_LOCK = "KMS:STATEMENT:AUTO_NOT_CONVERT:LOCK";
  /**
   * 结算单自动转换redis锁前缀
   * */
  public static final String STATEMENT_AUTO_FAIL_CONVERT_LOCK = "KMS:STATEMENT:AUTO_FAIL_CONVERT:LOCK";

  /**
   * 费用单转换成功描述
   */
  public static final String STATEMENT_CONVERT_SUCCESS_MSG = "转换成功";
}
