package com.biz.crm.kms.business.invoice.statement.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * @Class InvoiceStatementAccptanceDto
 * @Description 结算单-验收单Vo
 * @Author : ZS
 * @Date: 2022/11/29  16:19
 */
@Data
public class InvoiceStatementAccptanceDto {
    @ApiModelProperty("原始数据ID 对应表 kms_grab_response_data 的ID")
    private String rawDataId;

    /**
     * 单据单号
     */
    @ApiModelProperty("单据单号")
    private String documentCode;


    /**
     * 送达方编码
     */
    @ApiModelProperty("送达方编码")
    private String deliveryPartyCode;

    /**
     * 送达方名称
     */
    @ApiModelProperty("送达方名称")
    private String deliveryPartyName;

    /**
     * 零售商门店编码
     */
    @ApiModelProperty("零售商门店编码")
    private String supermarketStoreCode;


    @ApiModelProperty("零售商区域编码")
    private String areaCode;

    @ApiModelProperty("零售商区域名称")
    private String areaName;

    @ApiModelProperty("业务区域")
    private String businessArea;

    /**
     * 商超产品编号
     */
    @ApiModelProperty("零售商产品编号")
    private String kaproductCode;

    /**
     * 商超产品名称
     */
    @ApiModelProperty("零售商产品名称")
    private String kaproductName;


    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    private String productName;

    /**
     * 零售商单位
     */
    @ApiModelProperty("零售商单位")
    @TableField(value = "cur_unit")
    @Column(name = "cur_unit",length = 32 , columnDefinition = "varchar(32) COMMENT '零售商单位'")
    private String curUnit;

    /**
     * 零售商数量
     */
    @ApiModelProperty("零售商数量")
    private Integer curUnitOrderQuantity;

    /**
     * 转换后单位
     */
    @ApiModelProperty("转换后单位")
    private String convertedUnits;

    /**
     * 转换后数量
     */
    @ApiModelProperty("转换后数量")
    private Integer conversionQuantity;

    /**
     * 型号规格
     */
    @ApiModelProperty("型号规格")
    private String modelSpecification;

    /**
     * 单据金额小计(含税)
     */
    @ApiModelProperty("单据金额小计(含税)")
    private BigDecimal documentAmount;

    /**
     * 单据金额小计(不含税)
     */
    @ApiModelProperty("单据金额小计(不含税)")
    private BigDecimal documentAmountNot;
}
