package com.biz.crm.kms.business.invoice.statement.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * @Class InvoiceStatementDeductionDto
 * @Description 单据--结算单扣费明细
 * @Author : ZS
 * @Date: 2022/11/16  10:46
 */
@Data
public class InvoiceStatementDeductionDto extends TenantFlagOpDto {

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "")
    private String businessUnitCode;

    /**
     * 系统编码
     */
    @ApiModelProperty("系统编码")
    private String directCode;

    /**
     * 系统名称
     */
    @ApiModelProperty("系统名称")
    private String kaName;

    /**
     * 结算单号
     */
    @ApiModelProperty("结算单号")
    private String statementCode;

    /**
     * 单据日期
     */
    @ApiModelProperty("单据日期")
    private String orderDate;
    /**
     * 扣费明细单据单号
     */
    @ApiModelProperty("扣费明细单据单号")
    private String documentCode;

    /**
     * 扣费明细项编码
     */
    @ApiModelProperty("扣费明细项编码")
    private String deductionCode;

    /**
     * 扣费明细项名称
     */
    @ApiModelProperty("扣费明细项名称")
    private String deductionName;

    /**
     * 送达方编码
     */
    @ApiModelProperty("送达方编码")
    private String terminalCode;

    /**
     * 送达方名称
     */
    @ApiModelProperty("送达方名称")
    private String terminalName;

    /**
     * 售达方名称
     */
    @ApiModelProperty("售达方名称")
    private String soldToPartyName;

    /**
     * 售达方编码
     */
    @ApiModelProperty("售达方编码")
    private String soldToPartyCode;

    @ApiModelProperty("业务区域")
    private String businessArea;

    /**
     * 销售组织编码
     */
    @ApiModelProperty("销售组织编码")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty("销售组织名称")
    private String salesOrgName;

    @ApiModelProperty("企业产品编码")
    private String productCode;
    /**
     * 企业产品名称
     * 销售组织名称
     */
    @ApiModelProperty("企业产品名称")
    private String productName;

    @ApiModelProperty("扣费金额")
    private BigDecimal amount;

    @ApiModelProperty("开始时间")
    private String startTime;

    @ApiModelProperty("结束时间")
    private String endTime;

}
