package com.biz.crm.kms.business.invoice.statement.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;

/**
 * @Class InvoiceStatementDetailDto
 * @Description 单据--结算单明细表
 * @Author : ZS
 * @Date: 2022/11/16  10:50
 */
@Data
public class InvoiceStatementDetailDto {

    /**
     * 单据单号
     */
    @ApiModelProperty("单据单号")
    @TableField(value = "document_code")
    private String documentCode;

    /**
     * 企业门店编码
     */
    @ApiModelProperty(name = "企业门店编码", notes = "")
    private String terminalCode;

    /**
     * 门店名称
     */
    @ApiModelProperty(name = "企业门店门店名称", notes = "")
    private String terminalName;

    /**
     * 商超门店编码
     */
    @ApiModelProperty("商超门店编码")
    private String supermarketStoreCode;

    /**
     * 商超产品编号
     */
    @ApiModelProperty("商超产品编号")
    private String kaproductCode;

    /**
     * 商超产品名称
     */
    @ApiModelProperty("商超产品名称")
    private String kaproductName;

    /**
     * 产品国际条码
     */
    @ApiModelProperty("产品国际条码")
    private String goodsBarCode;

    /**
     * 企业产品编码
     */
    @ApiModelProperty("企业产品编码")
    private String productCode;

    /**
     * 企业产品名称
     */
    @ApiModelProperty("企业产品名称")
    private String productName;

    /**
     * 商超单位
     */
    @ApiModelProperty("商超单位")
    private String curUnit;

    /**
     * 商超数量
     */
    @ApiModelProperty("商超数量")
    private Integer curUnitOrderQuantity;

    /**
     * 转换后单位
     */
    @ApiModelProperty("转换后单位")
    private String convertedUnits;


    /**
     * 转换后数量
     */
    @ApiModelProperty("转换后数量")
    private Integer conversionQuantity;

    /**
     * 型号规格
     */
    @ApiModelProperty("型号规格")
    private String modelSpecification;
}
