package com.biz.crm.kms.business.invoice.statement.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

/**
 * @Class InvoiceStatementDto
 * @Description 单据--结算单请求参数
 * @Author : ZS
 * @Date: 2022/11/12  11:35
 */
@Data
public class InvoiceStatementDto extends TenantFlagOpDto {

    @ApiModelProperty("原始数据ID 对应表 kms_grab_response_data 的ID")
    private String rawDataId;

    /**
     * 系统编码
     */
    @ApiModelProperty("系统编码")
    private String directCode;

    @ApiModelProperty("零售商编码")
    private String kaCode;

    @ApiModelProperty("零售商名称")
    private String kaName;


    /**
     * 销售组织编码
     */
    @ApiModelProperty("销售组织编码")
    private String salesOrgCode;

    /**
     * 销售组织编码
     */
    @ApiModelProperty("销售组织名称")
    private String salesOrgName;

    /**
     * 直营门店编码
     */
    @ApiModelProperty("直营门店编码")
    private String directStoreCode;
    /**
     * 直营门店名称
     */
    @ApiModelProperty("直营门店名称")
    private String directStoreName;


    /**
     * 零售商门店名称
     */
    @ApiModelProperty("零售商门店名称")
    private String supermarketStoreName;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "")
    private String businessUnitCode;

    /**
     * 售达方名称
     */
    @ApiModelProperty("售达方名称")
    private String soldToPartyName;

    /**
     * 售达方编码
     */
    @ApiModelProperty("售达方编码")
    private String soldToPartyCode;

    /**
     * 结算单号
     */
    @ApiModelProperty("结算单号")
    private String statementCode;
    /**
     * 开始时间
     */
    @ApiModelProperty("开始时间")
    private String startTime;
    /**
     * 结束时间
     */
    @ApiModelProperty("结束时间")
    private String endTime;
    /**
     * 结算单日期
     */
    @ApiModelProperty("结算单日期")
    private String statementDate;
    /**
     * 零售商门店编码
     */
    @ApiModelProperty("零售商门店编码")
    private String supermarketStoreCode;
    /**
     * 结算金额(不含税)
     */
    @ApiModelProperty("结算金额(不含税)")
    private BigDecimal statementAmountNot;

    /**
     * 结算金额(含税)
     */
    @ApiModelProperty("结算金额(含税)")
    private BigDecimal statementAmount;

    /**
     * 结算单票扣金额
     */
    @ApiModelProperty("结算单票扣金额")
    private BigDecimal statementSingleTicket;

    /**
     * 结算单账扣金额
     */
    @ApiModelProperty("结算单账扣金额")
    private BigDecimal statementSingleAccount;

    /**
     * 零售商扣费总金额
     */
    @ApiModelProperty("零售商扣费总金额")
    private BigDecimal kaTotalAmount;

    /**
     * 单据来源
     */
    @ApiModelProperty("单据来源")
    private String invoicesSource;

    /**
     * 转换状态
     */
    @ApiModelProperty("转换状态")
    private String orderStatus;

    /**
     * 转换状态描述
     */
    @ApiModelProperty("转换状态描述")
    private String orderStatusMsg;

    /**
     * 结算单版本号
     */
    @ApiModelProperty("结算单版本号")
    private Integer versionNumber;

    @ApiModelProperty("零售商名称集合")
    private Set<String> KaNameList;

    @ApiModelProperty("零售商编码集合")
    private Set<String> kaCodeList;

    /**
     * 扣费明细表
     */
    @ApiModelProperty("扣费明细表")
    private List<InvoiceStatementDeductionDto> deductionDtoList;

    /**
     * 结算单明细表
     */
    @ApiModelProperty("结算单明细表")
    private List<InvoiceStatementDetailDto> detailDtoList;
}
