package com.biz.crm.kms.business.invoice.statement.sdk.event;

import com.biz.crm.kms.business.invoice.statement.sdk.dto.InvoiceStatementLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

public interface InvoiceStatementLogEventListener extends NebulaEvent {
    /**
     * 创建预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onCreate(InvoiceStatementLogEventDto dto);

    /**
     * 删除预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onDelete(InvoiceStatementLogEventDto dto);

    /**
     * 修改预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onUpdate(InvoiceStatementLogEventDto dto);

    /**
     * 启用预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onEnable(InvoiceStatementLogEventDto dto);

    /**
     * 禁用预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onDisable(InvoiceStatementLogEventDto dto);
    
    
}
