package com.biz.crm.kms.business.invoice.statement.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.business.invoice.statement.sdk.dto.InvoiceStatementDeductionDto;
import com.biz.crm.kms.business.invoice.statement.sdk.dto.InvoiceStatementDto;
import com.biz.crm.kms.business.invoice.statement.sdk.vo.InvoiceAcceptanceVo;
import com.biz.crm.kms.business.invoice.statement.sdk.vo.InvoiceExpenseSheetVo;
import com.biz.crm.kms.business.invoice.statement.sdk.vo.InvoiceReturnOrderVo;
import com.biz.crm.kms.business.invoice.statement.sdk.vo.InvoiceStatementDataVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @Description: 单据--结算单对外查询接口层
 * @Author: ZS
 * @Date: 2022/11/16
 */
public interface InvoiceStatementVoService {


    /**
     * 手动转换
     * @param rawDateIds 原始单据号
     */
    void manualSwitch(List<String> rawDateIds);


    /**
     * 查询所有结算单数据
     *
     * @param statementDto
     * @return
     */
    List<InvoiceStatementDto> findInvoiceStatement(InvoiceStatementDto statementDto);

    /**
     * 分页查询所有结算单数据
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<InvoiceStatementDto> findInvoiceStatementPaging(Pageable pageable, InvoiceStatementDto dto);

    /**
     * 查询验收单未关联结算单数据
     * @param dto
     * @return
     */
    Page<InvoiceAcceptanceVo> findNotMatchAccptance(Pageable pageable,InvoiceAcceptanceVo dto);

    /**
     * 查询退货单未关联结算单数据
     * @param dto
     * @return
     */
    Page<InvoiceReturnOrderVo> findNotMatchReturn(Pageable pageable,InvoiceReturnOrderVo dto);

    /**
     * 查找费用单中未关联结算单
     * @param dto
     * @return
     */
    Page<InvoiceExpenseSheetVo> findNotMatchExpense(Pageable pageable,InvoiceExpenseSheetVo dto);


    /**
     * 查询上月符合条件的所有数据
     *
     * @return 数据
     */
    List<InvoiceStatementDataVo> findAllByConditions(String businessUnitCode,String beginDateStr,String endDateStr);

    /**
     * 查询指定时间所在月份符合条件的所有数据
     *
     * @return 数据
     */
    List<InvoiceStatementDataVo> findAllByConditions(String date,String businessUnitCode);
    /**
     * 根据结算单号查询最大验收时间
     *
     * @param statementCode 结算单号
     * @return 数据
     */
    InvoiceStatementDataVo findByStatementCode(String statementCode);

    /**
     *  查询结算单的费用详情
     * @param pageable
     * @param dto
     * @return
     */
    Page<InvoiceStatementDeductionDto> findKmsStatementExpensePage(Pageable pageable, InvoiceStatementDeductionDto dto);
}
