package com.biz.crm.kms.business.invoice.statement.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 验收单表vo
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "验收单表Vo")
public class InvoiceAcceptanceVo extends TenantFlagOpVo {

  @ApiModelProperty("原始数据ID 对应表 kms_grab_response_data 的ID")
  private String rawDataId;

  @ApiModelProperty("系统编码")
  private String directCode;

  /**
   * 售达方名称
   */
  @ApiModelProperty("售达方名称")
  private String soldToPartyName;

  /**
   * 售达方编码
   */
  @ApiModelProperty("售达方编码")
  private String soldToPartyCode;

  /**
   * 单据单号
   */
  @ApiModelProperty("单据单号")
  private String documentCode;

  /**
   * 单据日期
   */
  @ApiModelProperty("单据日期")
  private String orderDate;

  /**
   * 企业门店编码
   */
  @ApiModelProperty(name = "企业门店编码", notes = "")
  private String terminalCode;

  /**
   * 门店名称
   */
  @ApiModelProperty(name = "企业门店门店名称", notes = "")
  private String terminalName;

  /**
   * 零售商门店编码
   */
  @ApiModelProperty("零售商门店编码")
  private String supermarketStoreCode;

  /**
   * 零售商门店名称
   */
  @ApiModelProperty("零售商门店名称")
  private String supermarketStoreName;

  /**
   * 单据金额小计(含税)
   */
  @ApiModelProperty("单据金额(含税)")
  private BigDecimal documentAmount;

  /**
   * 单据金额小计(不含税)
   */
  @ApiModelProperty("单据金额(不含税)")
  private BigDecimal documentAmountNot;

  /**
   * 零售商结算单号
   */
  @ApiModelProperty("零售商结算单号")
  private String statementCode;

  /**
   * 企业结算单号
   */
  @ApiModelProperty("企业结算单号")
  private String kmsStatementCode;

  /**
   * 结算单版本号
   */
  @ApiModelProperty("结算单版本号")
  private Integer versionNumber;

}

