package com.biz.crm.kms.business.invoice.statement.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * @Class InvoiceExpenseSheetVo
 * @Description 费用单Vo
 * @Author : ZS
 * @Date: 2022/11/26  17:26
 */
@Data
public class InvoiceExpenseSheetVo extends TenantFlagOpVo {

    /**
     * 原始数据ID
     */
    @ApiModelProperty("原始数据ID")
    private String rawDataId;

    /**
     * 售达方名称
     */
    @ApiModelProperty("售达方名称")
    private String soldToPartyName;

    /**
     * 售达方编码
     */
    @ApiModelProperty("售达方编码")
    private String soldToPartyCode;

    @ApiModelProperty("系统编码")
    private String directCode;

    /**
     * 单据单号
     */
    @ApiModelProperty("单据单号")
    private String documentCode;

    /**
     * 扣费明细项
     */
    @ApiModelProperty("扣费明细项编码")
    private String deductionCode;

    /**
     * 扣费明细项
     */
    @ApiModelProperty("扣费明细项名称")
    private String deductionName;

    /**
     * 企业门店编码
     */
    @ApiModelProperty(name = "企业门店编码", notes = "")
    private String terminalCode;

    /**
     * 门店名称
     */
    @ApiModelProperty(name = "企业门店门店名称", notes = "")
    private String terminalName;

    /**
     * 零售商门店编码
     */
    @ApiModelProperty("零售商门店编码")
    private String supermarketStoreCode;

    /**
     * 零售商门店名称
     */
    @ApiModelProperty("零售商门店名称")
    private String supermarketStoreName;
    /**
     * 单据日期
     */
    @ApiModelProperty("单据日期")
    private String orderDate;


    /**
     * 扣费金额（含税）
     */
    @ApiModelProperty("扣费金额（含税）")
    private BigDecimal amount;

    /**
     * 扣费金额（不含税）
     */
    @ApiModelProperty("扣费金额（不含税）")
    private BigDecimal amountNot;


    /**
     * 零售商结算单号
     */
    @ApiModelProperty("零售商结算单号")
    private String statementCode;

    /**
     * 企业结算单号
     */
    @ApiModelProperty("企业结算单号")
    private String kmsStatementCode;

    /**
     * 结算单版本号
     */
    @ApiModelProperty("结算单版本号")
    private Integer versionNumber;

    /**
     * 兑付方式
     */
    @ApiModelProperty("兑付方式")
    private String cashingType;

    /**
     * 结案形式
     */
    @ApiModelProperty("结案形式")
    private String auditWay;
}
