package com.biz.crm.kms.business.invoice.statement.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * @Class InvoiceReturnOrderVo
 * @Description 退货单Vo
 * @Author : ZS
 * @Date: 2022/11/26  17:08
 */
@Data
public class InvoiceReturnOrderVo extends TenantFlagOpVo {
    /**
     * 原始数据ID
     */
    @ApiModelProperty("原始数据ID")
    private String rawDataId;

    @ApiModelProperty("系统编码")
    private String directCode;

    /**
     * 售达方名称
     */
    @ApiModelProperty("售达方名称")
    private String soldToPartyName;

    /**
     * 售达方编码
     */
    @ApiModelProperty("售达方编码")
    private String soldToPartyCode;

    /**
     * 单据单号
     */
    @ApiModelProperty("单据单号")
    @TableField(value = "document_code")
    private String documentCode;

    /**
     * 企业门店编码
     */
    @ApiModelProperty(name = "企业门店编码", notes = "")
    private String terminalCode;

    /**
     * 门店名称
     */
    @ApiModelProperty(name = "企业门店门店名称", notes = "")
    private String terminalName;


    /**
     * 零售商门店编码
     */
    @ApiModelProperty("零售商门店编码")
    private String supermarketStoreCode;

    /**
     * 零售商门店名称
     */
    @ApiModelProperty("零售商门店名称")
    private String supermarketStoreName;
    /**
     * 单据金额(含税)
     */
    @ApiModelProperty("单据金额(含税)")
    private BigDecimal documentAmount;

    /**
     * 单据金额(不含税)
     */
    @ApiModelProperty("单据金额(不含税)")
    private BigDecimal documentAmountNot;

    /**
     * 零售商结算单号
     */
    @ApiModelProperty("零售商结算单号")
    private String statementCode;

    /**
     * 企业结算单号
     */
    @ApiModelProperty("企业结算单号")
    private String kmsStatementCode;

    /**
     * 结算单版本号
     */
    @ApiModelProperty("结算单版本号")
    private Integer versionNumber;

    /**
     * 单据日期
     */
    @ApiModelProperty("单据日期")
    private String orderDate;

    /**
     * 产品税率
     */
    @ApiModelProperty("产品税率")
    private BigDecimal proRate;

}
