package com.biz.crm.kms.business.invoice.statement.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 结算验收单数据vo
 */

@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "结算验收单数据vo")
public class InvoiceStatementDataVo extends TenantFlagOpVo {

    @ApiModelProperty("零售商名称")
    @Column(name = "customer_retailer_name")
    private String kaName;

    @ApiModelProperty("零售商编码")
    @Column(name = "customer_retailer_code")
    private String kaCode;

    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]")
    @Column(name = "business_format_code")
    private String businessFormatCode;

    @ApiModelProperty(name = "业务单元")
    @Column(name = "business_unit_code")
    private String businessUnitCode;

    @ApiModelProperty("售达方名称")
    @Column(name = "sold_to_party_name")
    private String soldToPartyName;

    @ApiModelProperty("售达方编码")
    @Column(name = "sold_to_party_code")
    private String soldToPartyCode;

    /**
     * 关联结算单号
     */
    @ApiModelProperty("关联结算单号")
    @Column(name = "statement_code")
    private String statementCode;

    /**
     * 关联结算日期
     */
    @ApiModelProperty("关联结算单日期")
    @Column(name = "statement_date")
    private String statementDate;
    /**
     * 结算金额
     */
    @ApiModelProperty("结算金额")
    @Column(name = "statement_amount")
    private BigDecimal statementAmount;

    @ApiModelProperty("票扣费用")
    @Column(name = "statement_single_ticket")
    private BigDecimal ticketDeductionAmount;

    @ApiModelProperty("账扣费用")
    @Column(name = "statement_single_amount")
    private BigDecimal accountDeductionAmount;

    @ApiModelProperty("货到时间")
    @Column(name = "acceptance_time")
    private Date acceptanceTime;

    @ApiModelProperty("系统编码")
    @Column(name = "direct_code")
    private String directCode;

    @ApiModelProperty("零售商扣费总金额")
    @Column(name = "ka_total_amount")
    private BigDecimal kaTotalAmount;
}
