package com.biz.crm.kms.business.invoice.stock.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.invoice.stock.local.service.StockGrabsService;
import com.biz.crm.kms.business.invoice.stock.sdk.service.StockVoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author cyj
 * @version 1.0
 * @date 2022/11/22 15:20
 * @description StockVoController
 */
@Slf4j
@Api(tags = "商超库存：StockVo：商超库存")
@RestController
@RequestMapping(value = {"/v1/stock/stockVo"})
public class StockVoController {

    @Autowired(required = false)
    private StockVoService stockVoService;

    @Autowired(required = false)
    private StockGrabsService service;

    /**
     * 库存数据手动转换
     * @param ids
     * @return
     */
    @ApiOperation(value = "库存数据手动转换")
    @PatchMapping(value = {"/manualSwitch"})
    public Result<?> manualSwitch(@RequestBody List<String> ids) {
        try {
            this.stockVoService.manualSwitch(ids);
            return Result.ok("转换结束");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("手动触发定时任务")
    @GetMapping("autoJob")
    public void autoJob(){
        this.service.autoNotConvertAcceptanceOrder();
    }

}
