package com.biz.crm.kms.business.invoice.stock.local.entity;



import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "Stock", description = "库存数据")
@Entity
@TableName("kms_invoice_stock")
@Table(name = "kms_invoice_stock" ,indexes = {
        @Index(name = "kms_invoice_stock_idx1", columnList = "direct_code"),
        @Index(name = "kms_invoice_stock_idx2", columnList = "ka_code"),
        @Index(name = "kms_invoice_stock_idx3", columnList = "ka_goods_code")
})
@org.hibernate.annotations.Table(appliesTo = "kms_invoice_stock", comment = "库存数据")
public class Stock extends TenantFlagOpEntity {

    @ApiModelProperty("原始数据ID 对应表 kms_grab_response_data 的ID")
    @TableField(value = "raw_data_id")
    @Column(name = "raw_data_id", length = 128, columnDefinition = "varchar(128) COMMENT '原始数据ID 对应表 kms_grab_response_data 的ID'")
    private String rawDataId;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;

    /**
     * 系统编码
     */
    @ApiModelProperty("系统编码")
    @Column(name = "direct_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '系统编码'")
    private String directCode;

    /**
     * 系统编码
     */
    @ApiModelProperty("系统名称")
    @Column(name = "direct_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '系统名称'")
    private String directName;

    /**
     * 费用单号
     */
    @ApiModelProperty("费用单号")
    @TableField(value = "invoice_expense_sheet_code")
    @Column(name = "invoice_expense_sheet_code", length = 32, columnDefinition = "varchar(32) COMMENT '费用单号'")
    private String invoiceExpenseSheetCode;

    @ApiModelProperty("送达方编码")
    @Column(name = "delivery_party_code", length = 64, columnDefinition = "varchar(32) COMMENT '送达方编码'")
    private String deliveryPartyCode;

    @ApiModelProperty("送达方名称")
    @Column(name = "delivery_party_name", length = 64, columnDefinition = "varchar(32) COMMENT '售达方名称'")
    private String deliveryPartyName;

    /**
     * 零售商区域编码
     */
    @ApiModelProperty("零售商区域编码")
    @Column(name = "area_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '零售商区域编码'")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String areaCode;

    /**
     * 零售商区域名称
     */
    @ApiModelProperty("零售商区域名称")
    @Column(name = "area_name", columnDefinition = "VARCHAR(255) COMMENT '零售商区域名称'")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String areaName;

    /**
     * 业务区域
     */
    @ApiModelProperty("业务区域")
    @Column(name = "business_area", length = 64, columnDefinition = "VARCHAR(64) COMMENT '业务区域'")
    private String businessArea;

    /**
     * 售达方名称
     */
    @ApiModelProperty("售达方名称")
    @Column(name = "sold_to_party_name", columnDefinition = "VARCHAR(255) COMMENT '售达方名称'")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String soldToPartyName;

    /**
     * 售达方编码
     */
    @ApiModelProperty("售达方编码")
    @Column(name = "sold_to_party_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '售达方编码'")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String soldToPartyCode;

    /**
     * 商超编码
     */
    @ApiModelProperty("商超编码")
    @Column(name = "ka_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '商超编码'")
    private String kaCode;

    /**
     * 商超名称
     */
    @ApiModelProperty("商超名称")
    @Column(name = "ka_name", columnDefinition = "VARCHAR(255) COMMENT '商超名称'")
    private String kaName;

    /**
     * 单据状态
     */
    @ApiModelProperty("单据状态")
    @Column(name = "invoice_status", columnDefinition = "VARCHAR(32) COMMENT '单据状态'")
    private String invoiceStatus;

    /**
     * 转换状态
     */
    @ApiModelProperty("转换状态")
    @Column(name = "order_status", length = 32, columnDefinition = "varchar(32) COMMENT '转换状态'")
    private String orderStatus;

    /**
     * 转换状态描述
     */
    @ApiModelProperty("转换状态描述")
    @Column(name = "order_status_msg", length = 128, columnDefinition = "varchar(128) COMMENT '转换状态描述'")
    private String orderStatusMsg;

    /**
     * 商超门店/大仓编号
     */
    @ApiModelProperty("商超门店/大仓编号")
    @Column(name = "ka_store_code", length = 32, columnDefinition = "varchar(32) COMMENT '商超门店/大仓编号'")
    private String kaStoreCode;

    /**
     * 商超门店/大仓名称
     */
    @ApiModelProperty("商超门店/大仓名称")
    @Column(name = "ka_store_name", length = 256, columnDefinition = "varchar(256) COMMENT '商超门店/大仓名称'")
    private String kaStoreName;

    /**
     * 产品国际码
     */
    @ApiModelProperty("产品国际码")
    @Column(name = "product_international_code",length = 32,columnDefinition = "varchar(32) COMMENT '产品国际码'")
    private String productInternationalCode;

    /**
     * 商超产品编号
     */
    @ApiModelProperty("商超产品编号")
    @Column(name = "ka_goods_code", length = 32, columnDefinition = "varchar(32) COMMENT '商超产品编号'")
    private String kaGoodsCode;

    /**
     * 商超产品名称
     */
    @ApiModelProperty("商超产品名称")
    @Column(name = "ka_goods_name", length = 255, columnDefinition = "varchar(255) COMMENT '商超产品名称'")
    private String kaGoodsName;

    /**
     * 企业产品编号
     */
    @ApiModelProperty("企业产品编号")
    @Column(name = "product_code", length = 32, columnDefinition = "varchar(32) COMMENT '企业产品编号'")
    private String productCode;

    /**
     * 企业产品名称
     */
    @ApiModelProperty("企业产品名称")
    @Column(name = "product_name", length = 255, columnDefinition = "varchar(255) COMMENT '企业产品名称'")
    private String productName;

    /**
     * 最小包装
     */
    @ApiModelProperty("最小包装")
    @Column(name = "min_package",length = 32,columnDefinition = "varchar(32) COMMENT '最小包装'")
    private String minPackage;

    /**
     * 最小包装库存数
     */
    @ApiModelProperty("最小包装库存数")
    @Column(name = "min_inventory_package",length = 32,columnDefinition = "varchar(32) COMMENT '最小包装库存数'")
    private String minInventoryPackage;

    /**
     * 客户库存数
     */
    @ApiModelProperty("客户库存数")
    @Column(name = "customer_inventory", length = 20, columnDefinition = "decimal(20,4) COMMENT '客户库存数'")
    private BigDecimal customerInventory;

    /**
     * 库存日期
     */
    @ApiModelProperty("库存日期")
    @Column(name = "inventory_date", length = 32, columnDefinition = "varchar(32) COMMENT '库存日期'")
    private String inventoryDate;

    @ApiModelProperty("单据日期(页面用)")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @TableField(value = "order_time")
    @Column(name = "order_time" , length = 32, columnDefinition = "datetime COMMENT '单据日期(页面用)'")
    private Date orderTime;

    /**
     * 库存金额
     */
    @ApiModelProperty("库存金额")
    @Column(name = "inventory_amount", length = 20, columnDefinition = "decimal(20,4) COMMENT '库存金额'")
    private BigDecimal inventoryAmount;

    /**
     * 库存金额(不含税)
     */
    @ApiModelProperty("库存金额(不含税)")
    @Column(name = "inventory_amount_not", length = 20, columnDefinition = "decimal(20,4) COMMENT '库存金额(不含税)'")
    private BigDecimal inventoryAmountNot;

    /**
     * 在途库存数
     */
    @ApiModelProperty("在途库存数")
    @Column(name = "in_transit_inventory", length = 8, columnDefinition = "int(8) COMMENT '在途库存数'")
    private BigDecimal inTransitInventory;

    /**
     * 在途库存金额
     */
    @ApiModelProperty("在途库存金额")
    @Column(name = "in_transit_amount", length = 20, columnDefinition = "decimal(20,4) COMMENT '在途库存金额'")
    private BigDecimal inTransitAmount;

    /**
     * 单据来源
     */
    @ApiModelProperty("单据来源")
    @Column(name = "invoices_source", length = 64, columnDefinition = "VARCHAR(64) COMMENT '单据来源'")
    private String invoicesSource;

    /**
     * 是否能再次转换标示(Y:是,N:否)
     */
    @ApiModelProperty("是否能再次转换标示(Y:是,N:否)")
    @Column(name = "trans_flag", length = 32, columnDefinition = "VARCHAR(32) COMMENT '是否能再次转换标示(Y:是,N:否)'")
    private String transFlag;

    /**
     * 单据版本号
     */
    @ApiModelProperty("单据版本号")
    @TableField(value = "version_number")
    @Column(name = "version_number", length = -1, columnDefinition = "int COMMENT '单据版本号'")
    private Integer versionNumber;

    /**
     * 库存产品组合键
     */
    @ApiModelProperty("库存产品组合键")
    @Column(name = "group_goods", length = 64, columnDefinition = "VARCHAR(64) COMMENT '库存产品组合键'")
    private String groupGoods;

    @ApiModelProperty("登录账号")
    @TableField(value = "user_name")
    @Column(name = "user_name", length = 64, columnDefinition = "varchar(64) COMMENT '登录账号'")
    private String userName;


    /**
     * 省编码(门店管理-省)
     */
    @ApiModelProperty("省编码(门店管理-省)")
    @Column(name = "province_code", length = 32, columnDefinition = "varchar(32) COMMENT '省编码(门店管理-省)'")
    private String provinceCode;

    /**
     * 省名称(门店管理-省)
     */
    @ApiModelProperty("省名称(门店管理-省)")
    @Column(name = "province_name", length = 32, columnDefinition = "varchar(32) COMMENT '省名称(门店管理-省)'")
    private String provinceName;
}
