package com.biz.crm.kms.business.invoice.stock.local.imports.model;


import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import lombok.Data;

import java.math.BigDecimal;

@Data
@CrmExcelImport(startRow = 2)
public class StockImportsVo extends CrmExcelVo {

    /**
     * 系统编码
     */
    @CrmExcelColumn(value = "*系统编码")
    private String directCode;

    /**
     * 系统名称
     */
    @CrmExcelColumn(value = "*系统名称")
    private String kaName;


    /**
     * 业态[数据字典:mdm_business_format]
     */
    @CrmExcelColumn(value = "*业态")
    private String businessFormatCode;

    /**
     * 业务单元
     */
    @CrmExcelColumn(value = "*业务单元")
    private String businessUnitCode;

    /**
     * 售达方编码
     */
    @CrmExcelColumn("*售达方编码")
    private String soldToPartyCode;

    /**
     * 售达方名称
     */
    @CrmExcelColumn("*售达方名称")
    private String soldToPartyName;

    /**
     * 送达方编码
     */
    @CrmExcelColumn(value = "*送达方编码")
    private String deliveryPartyCode;

    /**
     * 送达方名称
     */
    @CrmExcelColumn(value = "*送达方名称")
    private String deliveryPartyName;


    /**
     * 零售商门店编号
     */
    @CrmExcelColumn(value = "*零售商门店编号")
    private String kaStoreCode;

    /**
     * 零售商门店名称
     */
    @CrmExcelColumn(value = "*零售商门店名称")
    private String kaStoreName;

    /**
     * 零售商区域编码
     */
    @CrmExcelColumn(value = "零售商区域编码")
    private String areaCode;

    /**
     * 零售商区域名称
     */
    @CrmExcelColumn(value = "零售商区域名称")
    private String areaName;

    /**
     * 业务区域
     */
    @CrmExcelColumn(value = "业务区域")
    private String businessArea;

    /**
     * 产品国际码
     */
    @CrmExcelColumn(value = "*产品国际条码")
    private String productInternationalCode;

    /**
     * 产品编号
     */
    @CrmExcelColumn(value = "*产品编码")
    private String productCode;

    /**
     * 企业产品名称
     */
    @CrmExcelColumn(value = "*产品名称")
    private String productName;

    /**
     * 零售商产品编号
     */
    @CrmExcelColumn(value = "*零售商产品编码")
    private String kaGoodsCode;

    /**
     * 商超产品名称
     */
    @CrmExcelColumn(value = "*零售商产品名称")
    private String kaGoodsName;


    /**
     * 最小包装
     */
    @CrmExcelColumn(value = "最小包装")
    private String minPackage;

    /**
     * 最小包装库存数
     */
    @CrmExcelColumn(value = "最小包装库存数")
    private String minInventoryPackage;

    /**
     * 客户库存数
     */
    @CrmExcelColumn(value = "*客户库存数")
    private String customerInventoryStr;

    /**
     * 库存日期
     */
    @CrmExcelColumn(value = "*库存日期")
    private String inventoryDate;

    /**
     * 库存金额
     */
    @CrmExcelColumn(value = "*库存金额")
    private String inventoryAmountStr;

    /**
     * 在途库存数
     */
    @CrmExcelColumn(value = "在途库存数")
    private String inTransitInventoryStr;

    /**
     * 在途库存金额
     */
    @CrmExcelColumn(value = "在途库存金额")
    private String inTransitAmountStr;
}
