package com.biz.crm.kms.business.invoice.stock.local.repository;


import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.kms.business.invoice.sdk.enums.GrabTransStatus;
import com.biz.crm.kms.business.invoice.stock.local.entity.KmsInvoiceStockGrab;
import com.biz.crm.kms.business.invoice.stock.local.mapper.KmsInvoiceStockGrabMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * (KmsInvoiceStockGrab)表数据库访问层
 *
 * @author makejava
 * @since 2022-11-18 11:25:37
 */
@Component
public class KmsInvoiceStockGrabRepository extends ServiceImpl<KmsInvoiceStockGrabMapper, KmsInvoiceStockGrab> {

    /**
     * 根据费用单单号集合获取待转换记录
     *
     * @return
     */
    public List<KmsInvoiceStockGrab> findByidList(String tenantCode, List<String> idList) {
        return this.lambdaQuery()
                .eq(KmsInvoiceStockGrab::getTenantCode, tenantCode)
                .in(KmsInvoiceStockGrab::getId, idList)
                .list();
    }

    /**
     * 库存数据根据租户编码和转换状态查询库存数据带商品
     *
     * @param pageable
     * @param tenantCode
     * @param transStatusList
     * @return
     */
    public Page<String> findStockGrabPage(Pageable pageable, String tenantCode, List<String> transStatusList,String day) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        Page<String> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.baseMapper.findStockGrabPage(page, tenantCode, transStatusList,day);
    }


    /**
     * 根据商超产品编码集合和商超门店编码集合查询原始数据
     *
     * @param tenantCode
     * @param kaGoodsCodes
     * @param kaStoreCodes
     * @return
     */
    public List<KmsInvoiceStockGrab> findByTenantCodeAndKaGoodsCodesAndKaStoreCode(String tenantCode, List<String> kaGoodsCodes, List<String> kaStoreCodes) {
        return this.lambdaQuery()
                .eq(KmsInvoiceStockGrab::getTenantCode, tenantCode)
                .in(KmsInvoiceStockGrab::getKaGoodsCode, kaGoodsCodes)
                .in(KmsInvoiceStockGrab::getKaStoreCode, kaStoreCodes)
                .list();
    }


    /**
     * 根据库存数据id更新转换状态
     *
     * @param tenantCode  租户编码
     * @param transStatus 转换状态
     * @param idList      库存数据id集合
     */
    public void updateTransStatusByIds(String tenantCode, GrabTransStatus transStatus, List<String> idList) {
        if (StringUtils.isBlank(tenantCode)
                || Objects.isNull(transStatus)
                || CollectionUtil.isEmpty(idList)) {
            return;
        }
        this.lambdaUpdate()
                .eq(KmsInvoiceStockGrab::getTenantCode, tenantCode)
                .in(KmsInvoiceStockGrab::getId, idList)
                .set(KmsInvoiceStockGrab::getTransStatus, transStatus.getDictCode())
                .update();
    }
}

