package com.biz.crm.kms.business.invoice.stock.local.repository;



import com.biz.crm.kms.business.invoice.stock.local.entity.Stock;
import com.biz.crm.kms.business.invoice.stock.local.mapper.StockMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * (Stock)表数据库访问层
 *
 * @author makejava
 * @since 2022-11-09 17:05:27
 */
@Component
public class StockRepository extends ServiceImpl<StockMapper, Stock> {

  /**
   * 根据id集合更新启禁用装填
   * @param ids 分页对象
   * @param enableStatus 启禁用状态对象
   * @return
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
    this.lambdaUpdate()
            .in(Stock::getId, ids)
            .set(Stock::getEnableStatus, enableStatus.getCode())
            .update();
  }

  /**
   * 根据id集合查询集合
   */
  public List<Stock> findStockListByIds(String tenantCode,List<String> ids){

    return this.lambdaQuery()
            .eq(Stock::getTenantCode,tenantCode)
            .in(Stock::getId,ids).list();
  }
  /**
   * 根据id集合查询集合
   */
  public List<Stock> findStockListByGroupGoods(String tenantCode, Set<String> groupGoods){
    if (CollectionUtils.isEmpty(groupGoods)){
      return new ArrayList<>();
    }
    return this.lambdaQuery()
            .eq(Stock::getTenantCode,tenantCode)
            .in(Stock::getGroupGoods,groupGoods)
            .list();
  }

  /**
   * 通过唯一键查找数据
   */
  public Stock findGroupGoods(String tenantCode, String groupGoods){
    return this.lambdaQuery()
            .eq(Stock::getTenantCode,tenantCode)
            .eq(Stock::getGroupGoods,groupGoods)
            .one();
  }
  /**
   * 根据租户编码和原始单据id查询数据
   * @param tenantCode
   * @param rawId
   * @return
   */
  public Stock findByRawId(String tenantCode,String rawId){
    return this.lambdaQuery().eq(Stock::getTenantCode,tenantCode).eq(Stock::getId,rawId).one();
  }

  /**
   * 根据租户编码和商超产品编码和商超门店查询数据
   * @param tenantCode
   * @param kaGoodsCode
   * @param kaStoreCode
   * @return
   */
  public Stock findByKaGoodsCodeAndKaStoreCode(String tenantCode,String kaGoodsCode,String kaStoreCode){
    return this.lambdaQuery().eq(Stock::getTenantCode,tenantCode).eq(Stock::getKaGoodsCode,kaGoodsCode).eq(Stock::getKaStoreCode,kaStoreCode).one();
  }
}

