package com.biz.crm.kms.business.invoice.stock.local.service;


import com.biz.crm.kms.business.invoice.stock.local.entity.Stock;

import java.util.List;

/**
 * 库存数据抓取数据(python)表服务接口
 *
 * @author cyj
 * @date 2022-11-25 16:03:07
 */
public interface StockGrabsService {

  /**
   * 库存数据未转换单据自动解析定时任务
   */
  void autoNotConvertAcceptanceOrder();
  /**
   * 库存数据转换失败单据自动解析定时任务
   */
  void autoFailConvertAcceptanceOrder();


  /**
   * 转换
   *
   * @param groupGoods 库存数据ID集合
   */
  void manualSwitch(List<String> groupGoods);

  /**
   * 库存数据商超门店和商超产品转换
   *
   * @param entityList
   * @return void
   * @author: zs
   * @version: v1.0.0
   * @date: 2022.12.14 14:58
   */
  void convertOrder(List<Stock> entityList);



  /**
   * 过滤正在转换的库存数据唯一键
   *
   * @param groupGoods 库存数据集合
   * @return java.util.List<java.lang.String>
   * @author: zs
   * @version: v1.0.0
   * @date: 2022.12.14 1:45
   */
  void filterSwitchIngidList(List<String> groupGoods);
}
