package com.biz.crm.kms.business.invoice.stock.local.service;


import com.biz.crm.kms.business.invoice.stock.local.entity.Stock;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.Pageable;
import java.util.List;

/**
 * (Stock)表服务接口
 *
 * @author makejava
 * @since 2022-11-09 17:05:25
 */
public interface StockService{

   /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  Stock findById(String id);
  
   /**
   * 新增数据
   * @param stock 实体对象
   * @return 新增结果
   */
  Stock create(Stock stock);
  
   /**
   * 修改新据
   * @param stock 实体对象
   * @return 修改结果
   */
  Stock update(Stock stock);
  
  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);
  
  /**
   * 启用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 启用结果
   */
  void enable(List<String> idList);
  
  /**
   * 禁用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 禁用结果
   */
  void disable(List<String> idList);

    /**
     * 导入数据新增
     * @param stockList
     */
  void importSave(List<Stock> stockList);

}

