package com.biz.crm.kms.business.invoice.stock.local.service.internal;

import com.biz.crm.kms.business.invoice.stock.local.service.StockGrabsService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * 库存数据抓取数据(python)后自动转换     job
 *
 * @author: zs
 * @version: v1.0.0
 * @date: 2022.12.15 13:39
 */
@Slf4j
@Service
public class InvoiceStockAutoJob {


    @Autowired(required = false)
    private StockGrabsService stockGrabsService;


    /**
     * 定时任务自动转换库存数据
     */
    @DynamicTaskService(cornExpression = "0 0 1/2 * * ?", taskDesc = "库存数据未转换单据自动解析定时任务")
    public void autoNotConvertAcceptanceOrder() {
        //TODO  需要改成  定时任务分片+redis锁
        stockGrabsService.autoNotConvertAcceptanceOrder();
    }
    /**
     * 定时任务自动转换库存数据
     */
    @DynamicTaskService(cornExpression = "0 0 2/2 * * ?", taskDesc = "库存数据转换失败单据自动解析定时任务")
    public void autoFailConvertAcceptanceOrder() {
        //TODO  需要改成  定时任务分片+redis锁
        stockGrabsService.autoFailConvertAcceptanceOrder();
    }

}
