package com.biz.crm.kms.business.invoice.stock.local.service.internal;



import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.kms.business.invoice.stock.local.repository.StockRepository;
import com.biz.crm.kms.business.invoice.stock.local.entity.Stock;
import com.biz.crm.kms.business.invoice.stock.local.service.StockService;
import com.biz.crm.kms.business.invoice.stock.sdk.dto.StockDto;
import com.biz.crm.kms.business.invoice.stock.sdk.dto.StockLogEventDto;
import com.biz.crm.kms.business.invoice.stock.sdk.event.StockLogEventListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * (Stock)表服务实现类
 *
 * @author makejava
 * @since 2022-11-09 17:05:26
 */
@Service("stockService")
public class StockServiceImpl implements StockService {

  @Autowired
  private StockRepository stockRepository;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private NebulaNetEventClient nebulaNetEventClient;

  
  /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  @Override
  public Stock findById(String id) {
    if (StringUtils.isBlank(id)) {
	  return null;
	}
    return this.stockRepository.getById(id);
  }
  
  /**
   * 新增数据
   * @param stock 实体对象
   * @return 新增结果
   */
  @Transactional(rollbackFor = Exception.class)
  @Override
  public Stock create(Stock stock) {
    this.createValidate(stock);
    stock.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    stock.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    stock.setTenantCode(TenantUtils.getTenantCode());
    //数据来源说明
    stock.setInvoicesSource("");
    this.stockRepository.saveOrUpdate(stock);
    return stock;
  }
  
  /**
   * 修改新据
   * @param stock 实体对象
   * @return 修改结果
   */
  @Transactional(rollbackFor = Exception.class)
  @Override
  public Stock update(Stock stock) {
    this.updateValidate(stock);
    this.stockRepository.saveOrUpdate(stock);
    return stock;
  }
  
  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  @Transactional(rollbackFor = Exception.class)
  @Override
  public void delete(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
    this.stockRepository.removeByIds(idList);
  }
  
  /**
   * 启用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 启用结果
   */
  @Transactional(rollbackFor = Exception.class)
  @Override
  public void enable(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList), "启用数据时，主键集合不能为空！");
    this.stockRepository.updateEnableStatusByIds(idList, EnableStatusEnum.ENABLE);
  }
  
  /**
   * 禁用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 禁用结果
   */
  @Transactional(rollbackFor = Exception.class)
  @Override
  public void disable(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList), "禁用数据时，主键集合不能为空！");
    this.stockRepository.updateEnableStatusByIds(idList, EnableStatusEnum.DISABLE);
  }

  /**
   * 导入新增
   * @param stockList
   */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void importSave(List<Stock> stockList) {
      if (CollectionUtils.isEmpty(stockList)) {
        return;
      }
        stockList.forEach(aa->{
          aa.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
          aa.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
          aa.setTenantCode(TenantUtils.getTenantCode());
          //数据来源说明
          aa.setInvoicesSource("导入");
          this.create(aa);
        });

      Collection<StockDto> stockDtos = this.nebulaToolkitService.copyCollectionByWhiteList(stockList,Stock.class,StockDto.class, LinkedHashSet.class, ArrayList.class);
      // 业务日志创建
      stockDtos.forEach(dto -> {
        StockLogEventDto logEventDto = new StockLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(dto);
        SerializableBiConsumer<StockLogEventListener, StockLogEventDto> onCreate =
                StockLogEventListener::onCreate;
        this.nebulaNetEventClient.publish(logEventDto, StockLogEventListener.class, onCreate);
      });
    }

    /**
   * 创建验证
   * @param stock
   */
  private void createValidate(Stock stock)  {
    Validate.notNull(stock, "新增时，对象信息不能为空！");
    Validate.isTrue(StringUtils.isNotBlank(stock.getInventoryDate()),"库存时间不能为空");
    Stock entity = this.stockRepository.findGroupGoods(TenantUtils.getTenantCode(),stock.getGroupGoods());
    try {
      if (ObjectUtils.isNotEmpty(entity)) {
        if (entity.getCreateTime().compareTo(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(stock.getInventoryDate())) == -1) {
          this.stockRepository.removeById(entity.getId());
        }else
        {
          throw new RuntimeException("该产品库存的时间比当前时间更早");
        }
      }
    }catch (ParseException e){
      e.printStackTrace();
    }

	stock.setId(null);
     
  }
  
   /**
   * 修改验证
   * @param stock
   */
  private void updateValidate(Stock stock) {
    Validate.notNull(stock, "修改时，对象信息不能为空！");
      
  }
}

