package com.biz.crm.kms.business.invoice.stock.local.service.internal;


import com.biz.crm.kms.business.invoice.sdk.enums.InvoicesStatus;
import com.biz.crm.kms.business.invoice.stock.local.entity.Stock;
import com.biz.crm.kms.business.invoice.stock.local.repository.StockRepository;
import com.biz.crm.kms.business.invoice.stock.local.service.StockGrabsService;
import com.biz.crm.kms.business.invoice.stock.sdk.service.StockVoService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author cyj
 * @version 1.0
 * @date 2022/11/22 15:24
 * @description 库存表单实现类
 */
@Slf4j
@Service
public class StockVoServiceImpl implements StockVoService {

    @Autowired(required = false)
    private StockRepository stockRepository;

    @Autowired(required = false)
    private StockGrabsService stockGrabsService;

    @Override
    public void manualSwitch(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空！");
        List<Stock> entities = this.stockRepository.findStockListByIds(TenantUtils.getTenantCode(),ids);
        Validate.isTrue(!org.springframework.util.CollectionUtils.isEmpty(entities), "未查询到数据，请刷新重试");
        Validate.isTrue(!ObjectUtils.notEqual(entities.size(),ids.size()), "数据转换个数不匹配");
        entities.forEach(entity -> Validate.isTrue(Lists.newArrayList(InvoicesStatus.S200.getDictCode(), InvoicesStatus.S101.getDictCode(), InvoicesStatus.S100.getDictCode()).contains(entity.getOrderStatus())
                , String.format("库存数据ID[%s]已确认,无法继续匹配", entity.getId())));
        List<String> groupGoods = entities.stream()
                .filter(k -> StringUtils.isNotBlank(k.getGroupGoods()))
                .map(Stock::getGroupGoods).distinct().collect(Collectors.toList());
        //过滤正在转换的库存数据ID
        this.stockGrabsService.filterSwitchIngidList(groupGoods);
        log.info("===== 库存数据手动转换开始 ======");
        this.stockGrabsService.manualSwitch(groupGoods);
        log.info("===== 库存数据手动转换完成 ======");
    }

}
