/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.stock.local.imports.service;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.kms.business.invoice.stock.local.entity.Stock;
import com.biz.crm.kms.business.invoice.stock.local.imports.model.StockImportsVo;
import com.biz.crm.kms.business.invoice.stock.local.repository.StockRepository;
import com.biz.crm.kms.business.invoice.stock.local.service.StockService;
import com.biz.crm.kms.business.invoice.stock.local.util.DictValueUtil;
import com.biz.crm.kms.business.supermarket.sdk.service.SupermarketVoService;
import com.biz.crm.kms.business.supermarket.sdk.vo.SupermarketVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class StockImportsProcess
implements ImportProcess<StockImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(StockImportsProcess.class);
    @Resource
    private StockService stockService;
    @Resource
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private StockRepository stockRepository;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private SupermarketVoService supermarketVoService;

    public Map<Integer, String> execute(LinkedHashMap<Integer, StockImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Validate.notEmpty(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<Stock> importList = this.validate(data);
        this.stockService.importSave(importList);
        return null;
    }

    private List<Stock> validate(LinkedHashMap<Integer, StockImportsVo> data) {
        ArrayList<StockImportsVo> stockImportsVos = new ArrayList<StockImportsVo>(data.values());
        HashSet<String> groupGoods = new HashSet<String>();
        Set supermarketnames = stockImportsVos.stream().map(StockImportsVo::getKaName).collect(Collectors.toSet());
        List supermarketVos = this.supermarketVoService.findBySupermaketNames(supermarketnames);
        Map supermarketMaps = supermarketVos.stream().collect(Collectors.toMap(SupermarketVo::getSupermarketName, Function.identity()));
        ArrayList<Stock> entities = new ArrayList<Stock>();
        stockImportsVos.forEach(importsVo -> {
            Stock entity = (Stock)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)importsVo, Stock.class, HashSet.class, ArrayList.class, new String[0])));
            entity.setKaCode(((SupermarketVo)supermarketMaps.get(entity.getKaName())).getSupermarketCode());
            this.amountTrans((StockImportsVo)((Object)importsVo), entity);
            entity.setGroupGoods(entity.getKaCode() + "-" + entity.getDirectCode() + "-" + entity.getKaStoreCode() + "-" + entity.getKaGoodsCode());
            entities.add(entity);
            groupGoods.add(entity.getGroupGoods());
        });
        this.adjustData(entities);
        List<Stock> stockList = this.stockRepository.findStockListByGroupGoods(TenantUtils.getTenantCode(), groupGoods);
        if (!CollectionUtils.isEmpty(stockList)) {
            Map<String, String> stockMap = stockList.stream().collect(Collectors.toMap(Stock::getGroupGoods, UuidEntity::getId, (a, b) -> a));
            entities.forEach(x -> {
                if (stockMap.containsKey(x.getGroupGoods())) {
                    x.setId((String)stockMap.get(x.getGroupGoods()));
                }
            });
        }
        return entities;
    }

    public void amountTrans(StockImportsVo vo, Stock entity) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getInventoryDate()), (String)"\u5e93\u5b58\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getDirectCode()), (String)"\u7cfb\u7edf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getKaName()), (String)"\u7cfb\u7edf\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getBusinessFormatCode()), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getBusinessUnitCode()), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getSoldToPartyCode()), (String)"\u552e\u8fbe\u65b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getSoldToPartyName()), (String)"\u552e\u8fbe\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getDeliveryPartyCode()), (String)"\u9001\u8fbe\u65b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getDeliveryPartyName()), (String)"\u9001\u8fbe\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getKaStoreCode()), (String)"\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getKaStoreName()), (String)"\u95e8\u5e97\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getKaGoodsCode()), (String)"\u96f6\u552e\u5546\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getKaGoodsName()), (String)"\u96f6\u552e\u5546\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getProductCode()), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getProductName()), (String)"\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getCustomerInventoryStr()), (String)"\u5ba2\u6237\u5e93\u5b58\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getInventoryAmountStr()), (String)"\u5e93\u5b58\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)vo.getCustomerInventoryStr())) {
            BigDecimal customerInventory = new BigDecimal(vo.getCustomerInventoryStr());
            entity.setCustomerInventory(customerInventory);
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getInTransitAmountStr())) {
            BigDecimal inTransitAmount = new BigDecimal(vo.getInTransitAmountStr());
            entity.setInTransitAmount(inTransitAmount);
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getInventoryAmountStr())) {
            BigDecimal inventoryAmount = new BigDecimal(vo.getInventoryAmountStr());
            entity.setInventoryAmount(inventoryAmount);
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getInTransitInventoryStr())) {
            BigDecimal inTransitInventory = new BigDecimal(vo.getInTransitInventoryStr());
            entity.setInTransitInventory(inTransitInventory);
        }
    }

    private List<Stock> adjustData(List<Stock> data) {
        if (CollectionUtils.isEmpty(data)) {
            return new ArrayList<Stock>();
        }
        Map fomatMap = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"mdm_business_format"}));
        Map unitMap = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"mdm_business_unit"}));
        for (Stock entity : data) {
            entity.setBusinessFormatCode(DictValueUtil.findDictValue(fomatMap, "mdm_business_format", entity.getBusinessFormatCode()));
            entity.setBusinessUnitCode(DictValueUtil.findDictValue(unitMap, "mdm_business_unit", entity.getBusinessUnitCode()));
        }
        return data;
    }

    public Class<StockImportsVo> findCrmExcelVoClass() {
        return StockImportsVo.class;
    }

    public String getTemplateCode() {
        return "KMS_STOCK_PLAN_IMPORT";
    }

    public String getTemplateName() {
        return "KMS\u5e93\u5b58\u6570\u636e\u5bfc\u5165";
    }
}

