/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.stock.local.repository;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.kms.business.invoice.sdk.enums.GrabTransStatus;
import com.biz.crm.kms.business.invoice.stock.local.entity.KmsInvoiceStockGrab;
import com.biz.crm.kms.business.invoice.stock.local.mapper.KmsInvoiceStockGrabMapper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class KmsInvoiceStockGrabRepository
extends ServiceImpl<KmsInvoiceStockGrabMapper, KmsInvoiceStockGrab> {
    public List<KmsInvoiceStockGrab> findByidList(String tenantCode, List<String> idList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, idList)).list();
    }

    public Page<String> findStockGrabPage(Pageable pageable, String tenantCode, List<String> transStatusList, String day) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((KmsInvoiceStockGrabMapper)this.baseMapper).findStockGrabPage((Page<String>)page, tenantCode, transStatusList, day);
    }

    public List<KmsInvoiceStockGrab> findByTenantCodeAndKaGoodsCodesAndKaStoreCode(String tenantCode, List<String> kaGoodsCodes, List<String> kaStoreCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(KmsInvoiceStockGrab::getKaGoodsCode, kaGoodsCodes)).in(KmsInvoiceStockGrab::getKaStoreCode, kaStoreCodes)).list();
    }

    public void updateTransStatusByIds(String tenantCode, GrabTransStatus transStatus, List<String> idList) {
        if (StringUtils.isBlank((CharSequence)tenantCode) || Objects.isNull(transStatus) || CollectionUtil.isEmpty(idList)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, idList)).set(KmsInvoiceStockGrab::getTransStatus, (Object)transStatus.getDictCode())).update();
    }
}

