/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.stock.local.service.internal;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.direct.product.sdk.dto.DirectProductDto;
import com.biz.crm.kms.business.direct.product.sdk.service.DirectProductVoService;
import com.biz.crm.kms.business.direct.product.sdk.vo.DirectProductVo;
import com.biz.crm.kms.business.direct.sdk.service.DirectVoService;
import com.biz.crm.kms.business.direct.sdk.vo.DirectVo;
import com.biz.crm.kms.business.direct.store.sdk.dto.DirectStoreConditionDto;
import com.biz.crm.kms.business.direct.store.sdk.service.DirectStoreVoService;
import com.biz.crm.kms.business.direct.store.sdk.vo.DirectStoreVo;
import com.biz.crm.kms.business.invoice.sdk.enums.AutoConvertsEnum;
import com.biz.crm.kms.business.invoice.sdk.enums.ConstantEnums;
import com.biz.crm.kms.business.invoice.sdk.enums.GrabTransStatus;
import com.biz.crm.kms.business.invoice.sdk.enums.InvoicesStatus;
import com.biz.crm.kms.business.invoice.stock.local.entity.KmsInvoiceStockGrab;
import com.biz.crm.kms.business.invoice.stock.local.entity.Stock;
import com.biz.crm.kms.business.invoice.stock.local.register.InvoiceStockTypeRegister;
import com.biz.crm.kms.business.invoice.stock.local.repository.KmsInvoiceStockGrabRepository;
import com.biz.crm.kms.business.invoice.stock.local.repository.StockRepository;
import com.biz.crm.kms.business.invoice.stock.local.service.StockGrabsService;
import com.biz.crm.kms.business.invoice.stock.local.service.StockGrabsThreadService;
import com.biz.crm.kms.business.invoice.stock.sdk.constant.StockConstant;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.service.RedisCrmService;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="stockGrabsService")
public class StockGrabsServiceImpl
implements StockGrabsService {
    private static final Logger log = LoggerFactory.getLogger(StockGrabsServiceImpl.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;
    @Autowired(required=false)
    private DirectStoreVoService directStoreVoService;
    @Autowired(required=false)
    private RedisCrmService redisCrmService;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private DirectProductVoService directProductVoService;
    @Autowired(required=false)
    private StockRepository stockRepository;
    @Autowired(required=false)
    private InvoiceStockTypeRegister invoiceStockTypeRegister;
    @Autowired(required=false)
    private KmsInvoiceStockGrabRepository stockGrabRepository;
    @Autowired(required=false)
    private StockGrabsThreadService stockGrabsThreadService;
    @Autowired(required=false)
    private DirectVoService directVoService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void autoNotConvertAcceptanceOrder() {
        log.info("=====>    \u5e93\u5b58\u6570\u636e\u672a\u8f6c\u6362\u5355\u636e\u81ea\u52a8\u8f6c\u6362 start   <=====");
        boolean lock = this.redisMutexService.tryLock("KMS:STOCK:AUTO_NOT_CONVERT:LOCK", TimeUnit.SECONDS, StockConstant.STOCK_REDIS_TIME.intValue());
        if (!lock) {
            log.warn("\u5e93\u5b58\u6570\u636e\u672a\u8f6c\u6362\u5355\u636e\u81ea\u52a8\u8f6c\u6362\u4e2d,\u672c\u6b21\u81ea\u52a8\u8f6c\u6362\u88ab\u5ffd\u7565!");
            log.info("=====>    \u5e93\u5b58\u6570\u636e\u672a\u8f6c\u6362\u5355\u636e\u81ea\u52a8\u8f6c\u6362 end   <=====");
            return;
        }
        PageRequest pageable = PageRequest.of((int)1, (int)StockConstant.STOCK_PAGE_SIZE);
        ArrayList<String> transStatusList = new ArrayList<String>();
        transStatusList.add(GrabTransStatus.NOT_TRANS.getDictCode());
        String day = this.getDays(AutoConvertsEnum.NOT_CONVERTS.getDictCode());
        HashSet currentOrderNumberSet = new HashSet(StockConstant.STOCK_PAGE_SIZE);
        try {
            Page<String> orderNumberPage = this.stockGrabRepository.findStockGrabPage((Pageable)pageable, TenantUtils.getTenantCode(), transStatusList, day);
            currentOrderNumberSet.addAll(orderNumberPage.getRecords());
            this.sendMqMessage(orderNumberPage.getRecords());
            while (orderNumberPage.hasNext() && StockConstant.STOCK_LOOP_MAX >= pageable.getPageNumber()) {
                pageable = pageable.next();
                orderNumberPage = this.stockGrabRepository.findStockGrabPage((Pageable)pageable, TenantUtils.getTenantCode(), transStatusList, day);
                currentOrderNumberSet.clear();
                currentOrderNumberSet.addAll(orderNumberPage.getRecords());
                this.sendMqMessage(orderNumberPage.getRecords());
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            if (CollectionUtil.isNotEmpty(currentOrderNumberSet)) {
                this.redisCrmService.hdel("KMS:STOCK:CONVERT:LOCK", currentOrderNumberSet.toArray());
            }
        }
        finally {
            this.redisMutexService.unlock("KMS:STOCK:AUTO_NOT_CONVERT:LOCK");
        }
        log.info("=====>    \u5e93\u5b58\u6570\u636e\u672a\u8f6c\u6362\u5355\u636e\u81ea\u52a8\u8f6c\u6362 end   <=====");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void autoFailConvertAcceptanceOrder() {
        log.info("=====>    \u5e93\u5b58\u6570\u636e\u8f6c\u6362\u5931\u8d25\u5355\u636e\u81ea\u52a8\u8f6c\u6362 start   <=====");
        boolean lock = this.redisMutexService.tryLock("KMS:STOCK:AUTO_FAIL_CONVERT:LOCK", TimeUnit.SECONDS, StockConstant.STOCK_REDIS_TIME.intValue());
        if (!lock) {
            log.warn("\u5e93\u5b58\u6570\u636e\u8f6c\u6362\u5931\u8d25\u5355\u636e\u81ea\u52a8\u8f6c\u6362\u4e2d,\u672c\u6b21\u81ea\u52a8\u8f6c\u6362\u88ab\u5ffd\u7565!");
            log.info("=====>    \u5e93\u5b58\u6570\u636e\u8f6c\u6362\u5931\u8d25\u5355\u636e\u81ea\u52a8\u8f6c\u6362 end   <=====");
            return;
        }
        Pageable pageable = Pageable.ofSize((int)StockConstant.STOCK_PAGE_SIZE);
        ArrayList<String> transStatusList = new ArrayList<String>();
        transStatusList.add(GrabTransStatus.NOT_TRANS.getDictCode());
        String day = this.getDays(AutoConvertsEnum.FAIL_CONVERTS.getDictCode());
        HashSet currentOrderNumberSet = new HashSet(StockConstant.STOCK_PAGE_SIZE);
        try {
            Page<String> orderNumberPage = this.stockGrabRepository.findStockGrabPage(pageable, TenantUtils.getTenantCode(), transStatusList, day);
            currentOrderNumberSet.addAll(orderNumberPage.getRecords());
            this.sendMqMessage(orderNumberPage.getRecords());
            while (orderNumberPage.hasNext() && StockConstant.STOCK_LOOP_MAX >= pageable.getPageNumber()) {
                pageable = pageable.next();
                orderNumberPage = this.stockGrabRepository.findStockGrabPage(pageable, TenantUtils.getTenantCode(), transStatusList, day);
                currentOrderNumberSet.clear();
                currentOrderNumberSet.addAll(orderNumberPage.getRecords());
                this.sendMqMessage(orderNumberPage.getRecords());
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            if (CollectionUtil.isNotEmpty(currentOrderNumberSet)) {
                this.redisCrmService.hdel("KMS:STOCK:CONVERT:LOCK", currentOrderNumberSet.toArray());
            }
        }
        finally {
            this.redisMutexService.unlock("KMS:STOCK:AUTO_FAIL_CONVERT:LOCK");
        }
        log.info("=====>    \u5e93\u5b58\u6570\u636e\u8f6c\u6362\u5931\u8d25\u5355\u636e\u81ea\u52a8\u8f6c\u6362 end   <=====");
    }

    private void sendMqMessage(List<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return;
        }
        if (CollectionUtils.isEmpty(idList = idList.stream().filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList()))) {
            log.error("\u5e93\u5b58\u6570\u636e\u539f\u59cb\u5355\u636e\u6709\u7a7a\u6570\u636e[id]\u5b58\u5728!");
            return;
        }
        this.filterSwitchIngidList(idList);
        if (CollectionUtil.isEmpty(idList)) {
            return;
        }
        MqMessageVo message = new MqMessageVo();
        message.setMsgBody(JSON.toJSONString(idList));
        message.setTopic("KMS_STOCK_TOPIC" + RocketMqUtil.mqEnvironment());
        message.setTag("KMS_STOCK_MESSAGE_TAG");
        this.rocketMqProducer.sendMqMsg(message);
        try {
            Thread.sleep(200L);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    @Override
    public void manualSwitch(List<String> idList) {
        if (CollectionUtil.isEmpty(idList)) {
            log.warn("\u672a\u63a5\u6536\u5230\u9700\u8f6c\u6362\u5e93\u5b58\u6570\u636e\u53f7\uff01");
            return;
        }
        List<Stock> orderList = this.buildOrder(idList);
        this.convertOrder(orderList);
    }

    private List<Stock> buildOrder(List<String> idList) {
        log.info("--  \u7ec4\u88c5\u5355\u636e  --");
        if (CollectionUtil.isEmpty(idList)) {
            return Collections.emptyList();
        }
        List<KmsInvoiceStockGrab> entityGrabList = this.stockGrabRepository.findByidList(TenantUtils.getTenantCode(), idList);
        if (CollectionUtil.isEmpty(entityGrabList)) {
            log.warn("\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01");
            return Collections.emptyList();
        }
        int defaultVersionNumber = 1;
        entityGrabList.forEach(entity -> {
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            if (Objects.isNull(entity.getVersionNumber())) {
                entity.setVersionNumber(defaultVersionNumber);
            }
        });
        List entityList = (List)this.nebulaToolkitService.copyCollectionByBlankList(entityGrabList, KmsInvoiceStockGrab.class, Stock.class, HashSet.class, ArrayList.class, new String[0]);
        Map entityMap = entityList.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity(), (a, b) -> a.getVersionNumber() > b.getVersionNumber() ? a : b));
        ArrayList<Stock> convertData = new ArrayList<Stock>(entityMap.values());
        return convertData;
    }

    @Override
    public void convertOrder(List<Stock> entityList) {
        log.info("--  \u5355\u636e\u6240\u9700\u6570\u636e\u67e5\u8be2  --");
        if (CollectionUtils.isEmpty(entityList)) {
            return;
        }
        if (CollectionUtils.isEmpty(entityList = entityList.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getId())).collect(Collectors.toList()))) {
            return;
        }
        HashSet directCodeSet = Sets.newHashSet();
        ArrayList idList = Lists.newArrayList();
        HashSet kaStoreCodes = Sets.newHashSet();
        HashSet kaGoodsCodes = Sets.newHashSet();
        HashSet groupGoods = Sets.newHashSet();
        entityList.forEach(entity -> {
            entity.setOrderStatus(InvoicesStatus.S101.getDictCode());
            if (StringUtils.isNotEmpty((CharSequence)entity.getKaStoreCode())) {
                kaStoreCodes.add(entity.getKaStoreCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)entity.getDirectCode())) {
                directCodeSet.add(entity.getDirectCode());
            }
            idList.add(entity.getId());
            if (StringUtils.isNotBlank((CharSequence)entity.getKaGoodsCode())) {
                kaGoodsCodes.add(entity.getKaGoodsCode());
            }
            groupGoods.add(entity.getKaCode() + "-" + entity.getDirectCode() + "-" + entity.getKaStoreCode() + "-" + entity.getKaGoodsCode());
        });
        entityList = this.updateOldDataToNewData(groupGoods, entityList);
        if (CollectionUtils.isEmpty(entityList)) {
            return;
        }
        List directVos = this.directVoService.findByDirectCodes(directCodeSet.stream().collect(Collectors.toList()));
        HashMap directMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)directVos)) {
            directMap.putAll(directVos.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getBusinessUnitCode()) && StringUtils.isNotBlank((CharSequence)k.getBusinessFormatCode())).collect(Collectors.groupingBy(DirectVo::getDirectCode)));
        }
        Map<String, List<DirectStoreVo>> directStoreMap = this.buildStoreInfo(directCodeSet, kaStoreCodes);
        HashSet deliveryPartyCodeSet = Sets.newHashSet();
        if (CollectionUtil.isNotEmpty(directStoreMap)) {
            directStoreMap.values().stream().filter(CollUtil::isNotEmpty).forEach(directStoreVoList -> directStoreVoList.forEach(entity -> {
                deliveryPartyCodeSet.add(entity.getTerminalCode());
                if (StringUtils.isNotBlank((CharSequence)entity.getRetailerTerminalCode())) {
                    deliveryPartyCodeSet.add(entity.getRetailerTerminalCode());
                }
            }));
        }
        Map<String, List<DirectProductVo>> directProductMap = this.buildProductInfo(directCodeSet, deliveryPartyCodeSet, kaGoodsCodes);
        List entityGroupList = Lists.partition(entityList, (int)ConstantEnums.THREAD_SIZE.getValue());
        entityGroupList.stream().filter(CollUtil::isNotEmpty).forEach(asyncList -> this.stockGrabsThreadService.saveStockData((List<Stock>)asyncList, directMap, directStoreMap, directProductMap));
    }

    private Map<String, List<DirectStoreVo>> buildStoreInfo(Set<String> directCodeSet, Set<String> kaStoreCodes) {
        HashMap directStoreMap = Maps.newHashMap();
        if (CollectionUtil.isEmpty(kaStoreCodes) || CollectionUtil.isEmpty(directCodeSet)) {
            return directStoreMap;
        }
        DirectStoreConditionDto conditionDto = new DirectStoreConditionDto();
        conditionDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        conditionDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        conditionDto.setSupermarketStoreCodes(kaStoreCodes);
        conditionDto.setDirectCodes(directCodeSet);
        List directStoreList = this.directStoreVoService.findByDirectStoreConditionDto(conditionDto);
        if (CollectionUtil.isNotEmpty((Collection)directStoreList)) {
            directStoreMap.putAll(directStoreList.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getDirectCode())).filter(k -> StringUtils.isNotBlank((CharSequence)k.getSupermarketStoreCode())).collect(Collectors.groupingBy(k -> k.getDirectCode() + "_" + k.getSupermarketStoreCode())));
        }
        return directStoreMap;
    }

    private Map<String, List<DirectProductVo>> buildProductInfo(Set<String> directCodeSet, Set<String> deliveryPartyCodeSet, Set<String> kaGoodsCodes) {
        HashMap directProductMap = Maps.newHashMap();
        if (CollectionUtil.isEmpty(directCodeSet) || CollectionUtil.isEmpty(deliveryPartyCodeSet) || CollectionUtil.isEmpty(kaGoodsCodes)) {
            return directProductMap;
        }
        List kaProductCodeGroupList = Lists.partition((List)Lists.newArrayList(kaGoodsCodes), (int)ConstantEnums.PRODUCT_SIZE.getValue());
        DirectProductDto directProductDto = new DirectProductDto();
        directProductDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        directProductDto.setTenantCode(TenantUtils.getTenantCode());
        directProductDto.setOnShelfStatus(BooleanEnum.TRUE.getCapital());
        directProductDto.setDirectCodes(new ArrayList<String>(directCodeSet));
        directProductDto.setDeliveryPartyCodes(new ArrayList<String>(deliveryPartyCodeSet));
        directProductDto.setOrderType(this.invoiceStockTypeRegister.type());
        kaProductCodeGroupList.forEach(kaProductCodeList -> {
            directProductDto.setKaProductCodes(kaProductCodeList);
            List productList = this.directProductVoService.findByDirectProductDto(directProductDto);
            if (CollectionUtil.isNotEmpty((Collection)productList)) {
                directProductMap.putAll(productList.stream().filter(k -> BooleanEnum.TRUE.getCapital().equals(k.getOnShelfStatus())).filter(k -> StringUtils.isNotBlank((CharSequence)k.getDirectCode())).filter(k -> StringUtils.isNotBlank((CharSequence)k.getDeliveryPartyCode())).filter(k -> StringUtils.isNotBlank((CharSequence)k.getKaProductCode())).collect(Collectors.groupingBy(k -> k.getDirectCode() + "_" + k.getDeliveryPartyCode() + "_" + k.getKaProductCode())));
            }
        });
        return directProductMap;
    }

    private List<Stock> updateOldDataToNewData(Set<String> groupGoods, List<Stock> entityList) {
        if (CollectionUtil.isEmpty(groupGoods) || CollectionUtil.isEmpty(entityList)) {
            return entityList;
        }
        entityList.forEach(aa -> aa.setGroupGoods(aa.getKaCode() + "-" + aa.getDirectCode() + "-" + aa.getKaStoreCode() + "-" + aa.getKaGoodsCode()));
        ArrayList<Stock> newEntityList = new ArrayList<Stock>();
        List<Stock> oldEntityList = this.stockRepository.findStockListByGroupGoods(TenantUtils.getTenantCode(), groupGoods);
        if (!CollectionUtils.isEmpty(oldEntityList)) {
            List oldGroupGoods = oldEntityList.stream().map(Stock::getGroupGoods).collect(Collectors.toList());
            List<String> newGroupGoodss = groupGoods.stream().filter(f -> !oldGroupGoods.contains(f)).collect(Collectors.toList());
            Map<String, List<Stock>> newStockMap = entityList.stream().filter(f -> oldGroupGoods.contains(f.getGroupGoods())).collect(Collectors.groupingBy(Stock::getGroupGoods));
            for (Stock entity : oldEntityList) {
                newStockMap.get(entity.getGroupGoods()).sort((t1, t2) -> t2.getCreateTime().compareTo(t1.getCreateTime()));
                Stock stock = newStockMap.get(entity.getGroupGoods()).get(0);
                List<String> idList = newStockMap.get(entity.getGroupGoods()).stream().map(UuidEntity::getId).collect(Collectors.toList());
                if (entity.getCreateTime().compareTo(stock.getCreateTime()) == -1) {
                    idList = idList.stream().filter(id -> stock.getId().equals(id)).collect(Collectors.toList());
                    this.stockRepository.removeById((Serializable)((Object)entity.getId()));
                    newEntityList.add(stock);
                }
                if (entity.getCreateTime().compareTo(stock.getCreateTime()) == 0) {
                    this.stockRepository.removeById((Serializable)((Object)entity.getId()));
                    newEntityList.add(stock);
                }
                this.stockGrabRepository.updateTransStatusByIds(TenantUtils.getTenantCode(), GrabTransStatus.HAVE_TRANS, idList);
            }
            if (CollectionUtils.isEmpty(newGroupGoodss)) {
                Map<String, List<Stock>> newStockMapTwo = entityList.stream().filter(f -> !oldGroupGoods.contains(f.getGroupGoods())).collect(Collectors.groupingBy(Stock::getGroupGoods));
                newGroupGoodss.forEach(aa -> {
                    ((List)newStockMapTwo.get(aa)).sort((t1, t2) -> t2.getCreateTime().compareTo(t1.getCreateTime()));
                    Stock stock = (Stock)((Object)((Object)((List)newStockMapTwo.get(aa)).get(0)));
                    newEntityList.add(stock);
                });
            }
        } else {
            Map<String, List<Stock>> newStockMap = entityList.stream().collect(Collectors.groupingBy(Stock::getGroupGoods));
            groupGoods.forEach(bb -> {
                ((List)newStockMap.get(bb)).sort((t1, t2) -> t2.getCreateTime().compareTo(t1.getCreateTime()));
                Stock stock = (Stock)((Object)((Object)((List)newStockMap.get(bb)).get(0)));
                newEntityList.add(stock);
            });
        }
        return newEntityList;
    }

    @Override
    public void filterSwitchIngidList(List<String> groupGoods) {
        if (CollectionUtil.isEmpty(groupGoods)) {
            return;
        }
        List updateList = this.redisCrmService.hmget("KMS:STOCK:CONVERT:LOCK", new HashSet<String>(groupGoods));
        if (CollectionUtil.isNotEmpty((Collection)updateList)) {
            groupGoods.removeAll(updateList.stream().filter(Objects::nonNull).filter(k -> StringUtils.isNotEmpty((CharSequence)k.toString())).map(Object::toString).collect(Collectors.toList()));
        }
        Map<String, String> redisMap = groupGoods.stream().collect(Collectors.toMap(key -> key, key -> key, (oldValue, newValue) -> newValue));
        this.redisCrmService.hmset("KMS:STOCK:CONVERT:LOCK", redisMap, TimeUnit.SECONDS, (long)StockConstant.STOCK_REDIS_TIME.intValue());
    }

    private String getDays(String type) {
        Map fomatMap = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"kms_auto_converts"}));
        List vos = (List)fomatMap.get("kms_auto_converts");
        Optional<String> first = vos.stream().filter(a -> a.getDictCode().equals(type)).map(DictDataVo::getDictValue).findFirst();
        int past = Integer.parseInt(first.orElse(""));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, calendar.get(5) - past);
        String day = sdf.format(calendar.getTime());
        return day;
    }
}

