/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.stock.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.kms.business.direct.product.sdk.vo.DirectProductVo;
import com.biz.crm.kms.business.direct.sdk.vo.DirectVo;
import com.biz.crm.kms.business.direct.store.sdk.vo.DirectStoreVo;
import com.biz.crm.kms.business.invoice.sdk.enums.GrabTransStatus;
import com.biz.crm.kms.business.invoice.sdk.enums.InvoicesStatus;
import com.biz.crm.kms.business.invoice.stock.local.entity.Stock;
import com.biz.crm.kms.business.invoice.stock.local.repository.KmsInvoiceStockGrabRepository;
import com.biz.crm.kms.business.invoice.stock.local.repository.StockRepository;
import com.biz.crm.kms.business.invoice.stock.local.service.StockGrabsThreadService;
import com.biz.crm.kms.business.invoice.stock.sdk.enums.StockStatus;
import com.biz.crm.mn.common.base.service.RedisCrmService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="stockGrabsThreadService")
public class StockGrabsThreadServiceImpl
implements StockGrabsThreadService {
    private static final Logger log = LoggerFactory.getLogger(StockGrabsThreadServiceImpl.class);
    @Autowired
    private RedisService redisService;
    @Autowired
    private StockRepository stockRepository;
    @Autowired
    private KmsInvoiceStockGrabRepository stockGrabRepository;
    @Autowired
    private RedisCrmService redisCrmService;

    @Override
    @Async(value="grab3Thread")
    @Transactional(propagation=Propagation.NOT_SUPPORTED, rollbackFor={Exception.class})
    public void saveStockData(List<Stock> entities, Map<String, List<DirectVo>> directMap, Map<String, List<DirectStoreVo>> directStoreMap, Map<String, List<DirectProductVo>> directProductMap) {
        log.info("--  \u7ebf\u7a0b\u6c60\u5b58\u50a8\u5355\u636e --");
        if (CollectionUtil.isEmpty(entities)) {
            return;
        }
        List ids = entities.stream().map(UuidEntity::getId).collect(Collectors.toList());
        HashSet idsSet = new HashSet();
        HashSet idsSuccessSet = new HashSet();
        entities.stream().filter(Objects::nonNull).filter(k -> StringUtils.isNotBlank((CharSequence)k.getId())).forEach(entity -> {
            try {
                this.clearTransformInfoOne((Stock)((Object)entity), directMap);
                String deliveryCode = this.buildOrderInfoTwo((Stock)((Object)entity), directStoreMap);
                this.convertAcceptanceOrderItemThree((Stock)((Object)entity), directProductMap, deliveryCode);
                this.setOrderStatusAndMsgFour((Stock)((Object)entity));
                this.stockRepository.saveOrUpdate(entity);
                if (Objects.equals(InvoicesStatus.S200.getDictCode(), entity.getOrderStatus())) {
                    idsSuccessSet.add(entity.getId());
                } else {
                    idsSet.add(entity.getId());
                }
            }
            catch (Exception e) {
                log.error("\u4fdd\u5b58\u5e93\u5b58\u6570\u636e\u6570\u636e\u5931\u8d25", (Throwable)e);
                entity.setOrderStatus(InvoicesStatus.S100.getDictCode());
                entity.setTransFlag(BooleanEnum.TRUE.getCapital());
                entity.setOrderStatusMsg("\u8f6c\u6362\u65f6\u5f02\u5e38!");
                try {
                    this.stockRepository.saveOrUpdate(entity);
                }
                catch (Exception ex) {
                    log.error("", (Throwable)ex);
                }
            }
        });
        if (CollectionUtil.isEmpty(idsSet) && CollectionUtils.isEmpty(idsSuccessSet)) {
            return;
        }
        this.redisCrmService.hdel("KMS:STOCK:CONVERT:LOCK", new Object[]{ids});
        try {
            if (!CollectionUtil.isEmpty(idsSet)) {
                this.stockGrabRepository.updateTransStatusByIds(TenantUtils.getTenantCode(), GrabTransStatus.TRANS_FAIL, new ArrayList<String>(idsSet));
            }
            if (!CollectionUtil.isEmpty(idsSuccessSet)) {
                this.stockGrabRepository.updateTransStatusByIds(TenantUtils.getTenantCode(), GrabTransStatus.TRANS_FAIL, new ArrayList<String>(idsSuccessSet));
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    public void clearTransformInfoOne(Stock entity, Map<String, List<DirectVo>> directMap) {
        List<DirectVo> directVos;
        entity.setSoldToPartyName(null);
        entity.setSoldToPartyCode(null);
        entity.setDeliveryPartyCode(null);
        entity.setDeliveryPartyName(null);
        entity.setAreaName(null);
        entity.setAreaCode(null);
        if (StringUtils.isNotBlank((CharSequence)entity.getInventoryDate())) {
            try {
                entity.setOrderTime(new SimpleDateFormat("yyyy-MM-dd").parse(entity.getInventoryDate()));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (CollectionUtils.isEmpty(directVos = directMap.get(entity.getDirectCode()))) {
            entity.setOrderStatusMsg("\u4e0d\u5b58\u5728\u8be5\u7cfb\u7edf");
        } else {
            DirectVo directVo = directVos.get(0);
            entity.setBusinessFormatCode(directVo.getBusinessFormatCode());
            entity.setBusinessUnitCode(directVo.getBusinessUnitCode());
            entity.setKaName(directVo.getSupermarketName());
        }
    }

    public String buildOrderInfoTwo(Stock entity, Map<String, List<DirectStoreVo>> directStoreMap) {
        entity.setOrderStatus(StockStatus.S100.getDictCode());
        entity.setTransFlag(BooleanEnum.TRUE.getCapital());
        if (StringUtils.isBlank((CharSequence)entity.getDirectCode())) {
            entity.setOrderStatusMsg("\u7cfb\u7edf\u7f16\u7801\u4e3a\u7a7a");
            return null;
        }
        if (StringUtils.isBlank((CharSequence)entity.getKaStoreCode())) {
            entity.setOrderStatusMsg("\u5355\u636e\u5546\u8d85\u95e8\u5e97\u7f16\u7801\u4e3a\u7a7a");
            return null;
        }
        List<DirectStoreVo> directStoreList = directStoreMap.get(entity.getDirectCode() + "_" + entity.getKaStoreCode());
        DirectStoreVo directStoreVo = null;
        if (CollectionUtil.isEmpty(directStoreList)) {
            entity.setOrderStatusMsg("\u672a\u67e5\u8be2\u5230\u4e0e\u4f01\u4e1a\u95e8\u5e97\u5bf9\u5e94\u5173\u7cfb");
            return null;
        }
        if (directStoreList.size() > 1) {
            entity.setOrderStatusMsg("\u5546\u8d85\u95e8\u5e97\u4e0e\u4f01\u4e1a\u95e8\u5e97\u5bf9\u5e94\u5173\u7cfb\u5b58\u5728[" + directStoreList.size() + "]\u6761");
            return null;
        }
        directStoreVo = directStoreList.get(0);
        entity.setKaStoreCode(directStoreVo.getSupermarketStoreCode());
        if (StringUtils.isEmpty((CharSequence)entity.getKaStoreName())) {
            entity.setKaStoreName(directStoreVo.getSupermarketStoreName());
        }
        entity.setSoldToPartyCode(directStoreVo.getSoldToPartyCode());
        entity.setSoldToPartyName(directStoreVo.getSoldToPartyName());
        entity.setDeliveryPartyCode(directStoreVo.getTerminalCode());
        entity.setDeliveryPartyName(directStoreVo.getTerminalName());
        entity.setAreaName(directStoreVo.getRetailerRegion());
        entity.setBusinessArea(directStoreVo.getBusinessArea());
        entity.setProvinceCode(directStoreVo.getProvinceCode());
        entity.setProvinceName(directStoreVo.getProvinceName());
        return directStoreVo.getRetailerTerminalCode();
    }

    public void convertAcceptanceOrderItemThree(Stock entity, Map<String, List<DirectProductVo>> directProductMap, String deliveryCode) {
        List<DirectProductVo> productVos;
        entity.setOrderStatus(StockStatus.S100.getDictCode());
        if (StringUtils.isBlank((CharSequence)entity.getKaGoodsCode())) {
            entity.setOrderStatusMsg("\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a");
            return;
        }
        DirectProductVo productVo = null;
        List<Object> productVoList = new ArrayList<DirectProductVo>();
        List<DirectProductVo> productVoLists = directProductMap.get(entity.getDirectCode() + "_" + entity.getDeliveryPartyCode() + "_" + entity.getKaGoodsCode());
        if (CollectionUtil.isNotEmpty(productVoLists)) {
            productVoList.addAll(productVoLists);
        }
        if (CollectionUtil.isEmpty(productVoList) && StringUtils.isNotBlank((CharSequence)deliveryCode) && CollectionUtil.isNotEmpty(productVos = directProductMap.get(entity.getDirectCode() + "_" + deliveryCode + "_" + entity.getKaGoodsCode()))) {
            productVoList.addAll(productVos);
        }
        if (CollectionUtil.isEmpty(productVoList)) {
            entity.setOrderStatusMsg("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u5bf9\u5e94\u5173\u7cfb");
        } else if (productVoList.size() == 1) {
            productVo = (DirectProductVo)productVoList.get(0);
        } else {
            int allSize = productVoList.size();
            if (CollectionUtil.isEmpty(productVoList = productVoList.stream().filter(k -> BooleanEnum.TRUE.getCapital().equals(k.getIsDefault())).collect(Collectors.toList()))) {
                entity.setOrderStatusMsg("\u5171[" + allSize + "]\u6761\u5546\u54c1\u5bf9\u5e94\u5173\u7cfb,\u65e0\u9ed8\u8ba4\u5bf9\u5e94\u5173\u7cfb");
            } else if (productVoList.size() > 1) {
                entity.setOrderStatusMsg("[" + productVoList.size() + "]\u6761\u9ed8\u8ba4\u5546\u54c1\u5bf9\u5e94\u5173\u7cfb");
            } else {
                productVo = (DirectProductVo)productVoList.get(0);
            }
        }
        if (Objects.isNull(productVo)) {
            return;
        }
        entity.setDirectCode(productVo.getDirectCode());
        entity.setProductCode(productVo.getProductCode());
        entity.setProductName(productVo.getProductName());
        entity.setOrderStatus(StockStatus.S200.getDictCode());
    }

    public void setOrderStatusAndMsgFour(Stock entity) {
        if (Objects.equals(entity.getOrderStatus(), StockStatus.S200.getDictCode())) {
            entity.setOrderStatusMsg("\u8f6c\u6362\u6210\u529f");
        }
    }
}

