/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.stock.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.invoice.stock.local.entity.Stock;
import com.biz.crm.kms.business.invoice.stock.local.repository.StockRepository;
import com.biz.crm.kms.business.invoice.stock.local.service.StockService;
import com.biz.crm.kms.business.invoice.stock.sdk.dto.StockDto;
import com.biz.crm.kms.business.invoice.stock.sdk.dto.StockLogEventDto;
import com.biz.crm.kms.business.invoice.stock.sdk.event.StockLogEventListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="stockService")
public class StockServiceImpl
implements StockService {
    @Autowired
    private StockRepository stockRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Override
    public Stock findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (Stock)((Object)this.stockRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Stock create(Stock stock) {
        this.createValidate(stock);
        stock.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        stock.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        stock.setTenantCode(TenantUtils.getTenantCode());
        stock.setInvoicesSource("");
        this.stockRepository.saveOrUpdate((Object)stock);
        return stock;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Stock update(Stock stock) {
        this.updateValidate(stock);
        this.stockRepository.saveOrUpdate((Object)stock);
        return stock;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.stockRepository.removeByIds(idList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.stockRepository.updateEnableStatusByIds(idList, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.stockRepository.updateEnableStatusByIds(idList, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importSave(List<Stock> stockList) {
        if (CollectionUtils.isEmpty(stockList)) {
            return;
        }
        stockList.forEach(aa -> {
            aa.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            aa.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            aa.setTenantCode(TenantUtils.getTenantCode());
            aa.setInvoicesSource("\u5bfc\u5165");
            this.create((Stock)((Object)aa));
        });
        Collection stockDtos = this.nebulaToolkitService.copyCollectionByWhiteList(stockList, Stock.class, StockDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        stockDtos.forEach(dto -> {
            StockLogEventDto logEventDto = new StockLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer & Serializable onCreate = StockLogEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, StockLogEventListener.class, (SerializableBiConsumer)onCreate);
        });
    }

    private void createValidate(Stock stock) {
        block3: {
            Validate.notNull((Object)((Object)stock), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)stock.getInventoryDate()), (String)"\u5e93\u5b58\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Stock entity = this.stockRepository.findGroupGoods(TenantUtils.getTenantCode(), stock.getGroupGoods());
            try {
                if (!ObjectUtils.isNotEmpty((Object)((Object)entity))) break block3;
                if (entity.getCreateTime().compareTo(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(stock.getInventoryDate())) == -1) {
                    this.stockRepository.removeById((Serializable)((Object)entity.getId()));
                    break block3;
                }
                throw new RuntimeException("\u8be5\u4ea7\u54c1\u5e93\u5b58\u7684\u65f6\u95f4\u6bd4\u5f53\u524d\u65f6\u95f4\u66f4\u65e9");
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        stock.setId(null);
    }

    private void updateValidate(Stock stock) {
        Validate.notNull((Object)((Object)stock), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

