/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.stock.local.service.internal;

import com.biz.crm.kms.business.invoice.sdk.enums.InvoicesStatus;
import com.biz.crm.kms.business.invoice.stock.local.entity.Stock;
import com.biz.crm.kms.business.invoice.stock.local.repository.StockRepository;
import com.biz.crm.kms.business.invoice.stock.local.service.StockGrabsService;
import com.biz.crm.kms.business.invoice.stock.sdk.service.StockVoService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class StockVoServiceImpl
implements StockVoService {
    private static final Logger log = LoggerFactory.getLogger(StockVoServiceImpl.class);
    @Autowired(required=false)
    private StockRepository stockRepository;
    @Autowired(required=false)
    private StockGrabsService stockGrabsService;

    public void manualSwitch(List<String> ids) {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<Stock> entities = this.stockRepository.findStockListByIds(TenantUtils.getTenantCode(), ids);
        Validate.isTrue((!CollectionUtils.isEmpty(entities) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5", (Object[])new Object[0]);
        Validate.isTrue((!ObjectUtils.notEqual((Object)entities.size(), (Object)ids.size()) ? 1 : 0) != 0, (String)"\u6570\u636e\u8f6c\u6362\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        entities.forEach(entity -> Validate.isTrue((boolean)Lists.newArrayList((Object[])new String[]{InvoicesStatus.S200.getDictCode(), InvoicesStatus.S101.getDictCode(), InvoicesStatus.S100.getDictCode()}).contains(entity.getOrderStatus()), (String)String.format("\u5e93\u5b58\u6570\u636eID[%s]\u5df2\u786e\u8ba4,\u65e0\u6cd5\u7ee7\u7eed\u5339\u914d", entity.getId()), (Object[])new Object[0]));
        List<String> groupGoods = entities.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getGroupGoods())).map(Stock::getGroupGoods).distinct().collect(Collectors.toList());
        this.stockGrabsService.filterSwitchIngidList(groupGoods);
        log.info("===== \u5e93\u5b58\u6570\u636e\u624b\u52a8\u8f6c\u6362\u5f00\u59cb ======");
        this.stockGrabsService.manualSwitch(groupGoods);
        log.info("===== \u5e93\u5b58\u6570\u636e\u624b\u52a8\u8f6c\u6362\u5b8c\u6210 ======");
    }
}

