package com.biz.crm.kms.business.invoice.stock.sdk.constant;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

/**
 * 库存数据常量类
 *
 * @author cyj
 * @date 2022/11/29
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class StockConstant {

  /**
   * KMS单据验收单 MQ topic
   */
  public static final String KMS_STOCK_TOPIC = "KMS_STOCK_TOPIC";

  /**
   * 库存数据redis锁定时间
   * */
  public static final Integer STOCK_REDIS_TIME = 1800;

  /**
   * 库存数据自动转换 分页size
   */
  public static final Integer STOCK_PAGE_SIZE = 800;

  /**
   * 库存数据自动转换 分页后最大循环次数  和 上个参数配合使用
   * 自动转换单词最大自动转换数量为   {@link STOCK_PAGE_SIZE }*{@link STOCK_LOOP_MAX }
   */
  public static final Integer STOCK_LOOP_MAX = 1000;

  /**
   * 库存数据tag
   */
  public static final String STOCK_MESSAGE_TAG = "KMS_STOCK_MESSAGE_TAG";

  /**
   * 库存数据redis锁前缀
   */
  public static final String STOCK_CONVERT_LOCK = "KMS:STOCK:CONVERT:LOCK";

  /**
   * 库存数据自动转换redis锁前缀
   * */
  public static final String STOCK_AUTO_NOT_CONVERT_LOCK = "KMS:STOCK:AUTO_NOT_CONVERT:LOCK";

  /**
   * 库存数据自动转换redis锁前缀
   * */
  public static final String STOCK_AUTO_FAIL_CONVERT_LOCK = "KMS:STOCK:AUTO_FAIL_CONVERT:LOCK";

  /**
   * 库纯数据转换成功描述
   */
  public static final String STOCK_CONVERT_SUCCESS_MSG = "转换成功";
}
