package com.biz.crm.kms.business.invoice.stock.sdk.dto;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.biz.crm.kms.business.grab.rule.sdk.dto.GrabRuleStoreDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 库存数据抓单请求Dto
 * @author cyj
 * @version 1.0
 * @date 2022/11/23 16:30
 * @description StockGrabRuleDto
 */

@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "StockGrabRuleDto", description = "库存数据抓单规则Dto")
public class StockGrabRuleDto extends TenantDto {

    /**
     * 直营体系编码
     */
    @ApiModelProperty("直营体系编码")
    private String directCode;

    /**
     * 客户账号
     */
    @ApiModelProperty("客户账号")
    private String account;

    /**
     * 规则名称
     */
    @ApiModelProperty("规则名称")
    private String ruleName;

    /**
     * 单据类型
     */
    @ApiModelProperty("单据类型")
    private String orderType;

    /**
     * 是否是全部门店(Y:是,N:否)
     * @see com.biz.crm.business.common.sdk.enums.BooleanEnum
     */
    @ApiModelProperty("是否是全部门店(Y:是,N:否)")
    private String allStoreFlag;

    /**
     * 规则参数
     */
    @ApiModelProperty("规则参数")
    private List<JSONObject> ruleParam;

    /**
     * 门店列表
     */
    @ApiModelProperty("门店列表")
    private List<GrabRuleStoreDto> storeList;

}
