package com.biz.crm.kms.business.invoice.stock.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @Class SrockVo
 * @Description 库存数据
 * @Author : ZS
 * @Date: 2022/11/10  16:18
 */
@Data
public class SrockVo extends TenantFlagOpVo{

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "")
    private String businessUnitCode;

    /**
     * 商超编码
     */
    @ApiModelProperty("商超编码")
    private String kaCode;

    /**
     * 商超名称
     */
    @ApiModelProperty("商超名称")
    private String kaName;

    /**
     * 单据状态
     */
    @ApiModelProperty("单据状态")
    private String invoiceStatus;

    /**
     * 转换状态
     */
    @ApiModelProperty("转换状态")
    private String orderStatus;

    /**
     * 转换状态描述
     */
    @ApiModelProperty("转换状态描述")
    private String orderStatusMsg;

    /**
     * 商超门店/大仓编号
     */
    @ApiModelProperty("商超门店/大仓编号")
    private String kaStoreCode;

    /**
     * 商超门店/大仓名称
     */
    @ApiModelProperty("商超门店/大仓名称")
    private String kaStoreName;

    /**
     * 产品国际码
     */
    @ApiModelProperty("产品国际码")
    private String productInternationalCode;

    /**
     * 商超产品编号
     */
    @ApiModelProperty("商超产品编号")
    private String kaGoodsCode;

    /**
     * 商超产品名称
     */
    @ApiModelProperty("商超产品名称")
    private String kaGoodsName;

    /**
     * 企业产品编号
     */
    @ApiModelProperty("企业产品编号")
    private String productCode;

    /**
     * 企业产品名称
     */
    @ApiModelProperty("企业产品名称")
    private String productName;

    /**
     * 最小包装
     */
    @ApiModelProperty("最小包装")
    private String minPackage;

    /**
     * 最小包装库存数
     */
    @ApiModelProperty("最小包装库存数")
    private String minInventoryPackage;

    /**
     * 客户库存数
     */
    @ApiModelProperty("客户库存数")
    private BigDecimal customerInventory;

    /**
     * 库存日期
     */
    @ApiModelProperty("库存日期")
    private String inventoryDate;

    /**
     * 库存金额
     */
    @ApiModelProperty("库存金额")
    private BigDecimal inventoryAmount;

    /**
     * 在途库存数
     */
    @ApiModelProperty("在途库存数")
    private Integer inTransitInventory;

    /**
     * 在途库存金额
     */
    @ApiModelProperty("在途库存金额")
    private BigDecimal inTransitAmount;

    /**
     * 单据来源
     */
    @ApiModelProperty("单据来源")
    private String invoicesSource;
}
