/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.reconciliation.manage.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.reconciliation.manage.sdk.dto.ReconciliationDto;
import com.biz.crm.kms.business.reconciliation.manage.sdk.service.ReconciliationService;
import com.biz.crm.kms.business.reconciliation.manage.sdk.vo.ReconciliationVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/reconciliation/manage"})
@Api(tags={"\u5bf9\u8d26\u5355\u63a7\u5236\u5c42"})
public class ReconciliationController {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationController.class);
    @Resource
    private ReconciliationService reconciliationService;

    @DeleteMapping
    @ApiOperation(value="\u5bf9\u8d26\u5355\u5220\u9664\u6570\u636e\uff08\u5355\u4e2a\u6216\u8005\u6279\u91cf\uff09")
    public Result<?> delete(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="ids") List<String> ids) {
        try {
            this.reconciliationService.deleteByIds(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"/findById"})
    @ApiOperation(value="\u67e5\u8be2\u5bf9\u8d26\u5355\u660e\u7ec6,\u5e26\u53d1\u7968\u4fe1\u606f")
    public Result<ReconciliationVo> findById(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam(value="id") String id) {
        try {
            ReconciliationVo reconciliationVo = this.reconciliationService.findById(id);
            return Result.ok((Object)reconciliationVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u5bf9\u8d26\u5355\u4fee\u6539\u6570\u636e")
    public Result<?> update(@ApiParam(name="ReconciliationDto", value="\u5bf9\u8d26\u5355\u5165\u53c2") @RequestBody ReconciliationDto dto) {
        try {
            this.reconciliationService.update(dto);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539\u5907\u6ce8")
    @PostMapping(value={"/addOrUpdateRemark"})
    public Result<?> addOrUpdateRemark(@ApiParam(name="id", value="\u5bf9\u8d26\u5355\u5165\u53c2") @RequestParam(value="id") String id, @RequestParam(value="remark") String remark) {
        try {
            this.reconciliationService.addOrUpdateRemark(id, remark);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fdd\u5b58\u56de\u6b3e\u5dee\u5f02\u5904\u7406")
    @PostMapping(value={"/saveDiscrepancy"})
    public Result<?> saveDiscrepancy(@ApiParam(name="dto", value="\u56de\u6b3e\u5dee\u5f02\u5904\u7406\u6570\u636e") @RequestBody ReconciliationDto dto) {
        try {
            this.reconciliationService.saveDiscrepancy(dto);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5b9a\u65f6\u751f\u6210\u7ed3\u7b97\u5355\u6570\u636e")
    @GetMapping(value={"synchronize"})
    public Result<?> synchronize() {
        try {
            this.reconciliationService.synchronize();
            return Result.ok((String)"\u540c\u6b65\u6210\u529f\uff01");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<ReconciliationVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u5e93\u5b58\u76d8\u70b9") ReconciliationDto dto) {
        try {
            Page page = this.reconciliationService.findByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u540c\u6b65\u6307\u5b9a\u65f6\u95f4\u6240\u5728\u6708\u7ed3\u7b97\u5355\u6570\u636e")
    @GetMapping(value={"synchronize/{dateData}"})
    public Result<?> synchronize(@PathVariable @ApiParam(name="dateData", value="\u6307\u5b9a\u65f6\u95f4(yyyy-MM-dd)") String dateData) {
        try {
            this.reconciliationService.synchronize(dateData);
            return Result.ok((String)"\u540c\u6b65\u6210\u529f\uff01");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

