/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.reconciliation.manage.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.kms.business.reconciliation.manage.local.entity.ReconciliationEntity;
import com.biz.crm.kms.business.reconciliation.manage.local.mapper.ReconciliationMapper;
import com.biz.crm.kms.business.reconciliation.manage.sdk.dto.ExposureConditionsDto;
import com.biz.crm.kms.business.reconciliation.manage.sdk.dto.ReconciliationDto;
import com.biz.crm.kms.business.reconciliation.manage.sdk.vo.ReconciliationVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class ReconciliationRepository
extends ServiceImpl<ReconciliationMapper, ReconciliationEntity> {
    @Autowired
    private ReconciliationMapper reconciliationMapper;

    public List<ReconciliationEntity> findByIds(List<String> ids) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(UuidEntity::getId, ids)).list();
    }

    public void deleteByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(UuidEntity::getId, ids)).remove();
    }

    public ReconciliationVo findById(String id) {
        return this.reconciliationMapper.findById(id, TenantUtils.getTenantCode());
    }

    public ReconciliationVo findOneByConditions(ExposureConditionsDto dto) {
        return this.reconciliationMapper.findOneByConditions(dto);
    }

    public Page<ReconciliationVo> findByConditions(Pageable pageable, ReconciliationDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<ReconciliationVo> pageList = this.reconciliationMapper.findByConditions((Page<ReconciliationVo>)page, dto);
        return pageList;
    }

    public List<String> getByIds(List<String> ids) {
        List<String> repetitionIds = this.reconciliationMapper.getByIds(ids);
        if (repetitionIds == null || repetitionIds.size() == 0) {
            return new ArrayList<String>();
        }
        return repetitionIds;
    }

    public List<String> findSoldPartyCodes() {
        return this.reconciliationMapper.findSoldPartyCodes(TenantUtils.getTenantCode());
    }
}

