/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.reconciliation.manage.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.reconciliation.manage.local.entity.BackToArticleRelationEntity;
import com.biz.crm.kms.business.reconciliation.manage.local.repository.BackToArticleRepository;
import com.biz.crm.kms.business.reconciliation.manage.local.service.BackToArticleService;
import com.biz.crm.kms.business.reconciliation.manage.sdk.dto.BackToArticleDto;
import com.biz.crm.kms.business.reconciliation.manage.sdk.vo.BackToArticleVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="backToArticleService")
public class BackToArticleServiceImpl
implements BackToArticleService {
    @Autowired(required=false)
    private BackToArticleRepository backToArticleRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<BackToArticleVo> findByConditions(Pageable pageable, BackToArticleDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        dto = (BackToArticleDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new BackToArticleDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.backToArticleRepository.findByConditions(pageable, dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createBackToArticle(List<BackToArticleDto> backToArticleDtoList) {
        if (CollectionUtils.isEmpty(backToArticleDtoList)) {
            return;
        }
        this.createValidate(backToArticleDtoList);
        backToArticleDtoList.forEach(x -> {
            x.setReturnDate(DateUtil.format((Date)DateUtil.getDateByFormat((String)x.getReturnDate(), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
            x.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            x.setTenantCode(TenantUtils.getTenantCode());
            x.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        });
        List backToArticleEntities = (List)this.nebulaToolkitService.copyCollectionByBlankList(backToArticleDtoList, BackToArticleDto.class, BackToArticleRelationEntity.class, HashSet.class, ArrayList.class, new String[0]);
        this.backToArticleRepository.deleteByRelationId(backToArticleDtoList.get(0).getRelationId());
        this.backToArticleRepository.saveOrUpdateBatch(backToArticleEntities);
    }

    private void createValidate(List<BackToArticleDto> backToArticleDtoList) {
    }
}

