/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.reconciliation.manage.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.reconciliation.manage.local.entity.DiscrepancyFeeEntity;
import com.biz.crm.kms.business.reconciliation.manage.local.repository.DiscrepancyFeeRepository;
import com.biz.crm.kms.business.reconciliation.manage.local.service.DiscrepancyFeeService;
import com.biz.crm.kms.business.reconciliation.manage.sdk.dto.DiscrepancyFeeDto;
import com.biz.crm.kms.business.reconciliation.manage.sdk.vo.DiscrepancyFeeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="discrepancyFeeService")
public class DiscrepancyFeeServiceImpl
implements DiscrepancyFeeService {
    @Autowired(required=false)
    private DiscrepancyFeeRepository discrepancyFeeRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<DiscrepancyFeeVo> findByConditions(Pageable pageable, DiscrepancyFeeDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new DiscrepancyFeeDto();
        }
        return this.discrepancyFeeRepository.findByConditions(pageable, dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createDiscrepancyFee(List<DiscrepancyFeeDto> discrepancyFeeDtoList) {
        if (CollectionUtils.isEmpty(discrepancyFeeDtoList)) {
            return;
        }
        this.createValidate(discrepancyFeeDtoList);
        discrepancyFeeDtoList.forEach(x -> {
            x.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            x.setTenantCode(TenantUtils.getTenantCode());
            x.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        });
        List discrepancyFeeEntities = (List)this.nebulaToolkitService.copyCollectionByBlankList(discrepancyFeeDtoList, DiscrepancyFeeDto.class, DiscrepancyFeeEntity.class, HashSet.class, ArrayList.class, new String[0]);
        this.discrepancyFeeRepository.saveOrUpdateBatch(discrepancyFeeEntities);
    }

    private void createValidate(List<DiscrepancyFeeDto> discrepancyFeeDtoList) {
    }
}

