/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.reconciliation.manage.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.reconciliation.manage.local.entity.InvoiceMessageEntity;
import com.biz.crm.kms.business.reconciliation.manage.local.repository.InvoiceMessageRepository;
import com.biz.crm.kms.business.reconciliation.manage.local.service.InvoiceMessageService;
import com.biz.crm.kms.business.reconciliation.manage.sdk.dto.InvoiceMessageDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="invoiceMessageService")
public class InvoiceMessageServiceImpl
implements InvoiceMessageService {
    @Autowired(required=false)
    private InvoiceMessageRepository invoiceMessageRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createInvoiceMessage(List<InvoiceMessageDto> invoiceMessageDtoList) {
        if (CollectionUtils.isEmpty(invoiceMessageDtoList)) {
            return;
        }
        this.createValidate(invoiceMessageDtoList);
        invoiceMessageDtoList.forEach(x -> {
            x.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            x.setTenantCode(TenantUtils.getTenantCode());
            x.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        });
        List InvoiceEntities = (List)this.nebulaToolkitService.copyCollectionByBlankList(invoiceMessageDtoList, InvoiceMessageDto.class, InvoiceMessageEntity.class, HashSet.class, ArrayList.class, new String[0]);
        this.invoiceMessageRepository.deleteByRelationId(invoiceMessageDtoList.get(0).getRelationId());
        this.invoiceMessageRepository.saveOrUpdateBatch(InvoiceEntities);
    }

    public void createValidate(List<InvoiceMessageDto> invoiceMessageDtoList) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        Date end = null;
        Date start = null;
        for (InvoiceMessageDto i : invoiceMessageDtoList) {
            String invoiceEndDate = i.getInvoiceEndDate();
            String invoiceStartDate = i.getInvoiceStartDate();
            Validate.notBlank((CharSequence)invoiceEndDate, (String)"\u7968\u5230\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)invoiceStartDate, (String)"\u5f00\u7968\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            try {
                end = sf.parse(invoiceEndDate);
                start = sf.parse(invoiceStartDate);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            Validate.isTrue((!start.after(end) ? 1 : 0) != 0, (String)"\u5f00\u7968\u65f6\u95f4\u4e0d\u80fd\u5728\u7968\u5230\u65f6\u95f4\u4e4b\u540e\uff01", (Object[])new Object[0]);
        }
    }
}

