/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.reconciliation.manage.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.kms.business.financial.auditing.sdk.service.AuditService;
import com.biz.crm.kms.business.financial.auditing.sdk.vo.AuditVo;
import com.biz.crm.kms.business.invoice.statement.sdk.service.InvoiceStatementVoService;
import com.biz.crm.kms.business.invoice.statement.sdk.vo.InvoiceStatementDataVo;
import com.biz.crm.kms.business.reconciliation.manage.local.entity.ReconciliationEntity;
import com.biz.crm.kms.business.reconciliation.manage.local.repository.ReconciliationRepository;
import com.biz.crm.kms.business.reconciliation.manage.local.service.BackToArticleService;
import com.biz.crm.kms.business.reconciliation.manage.local.service.DiscrepancyFeeService;
import com.biz.crm.kms.business.reconciliation.manage.local.service.InvoiceMessageService;
import com.biz.crm.kms.business.reconciliation.manage.local.service.ReconciliationTransService;
import com.biz.crm.kms.business.reconciliation.manage.sdk.dto.ActivityContractEventDto;
import com.biz.crm.kms.business.reconciliation.manage.sdk.dto.BackToArticleDto;
import com.biz.crm.kms.business.reconciliation.manage.sdk.dto.ExposureConditionsDto;
import com.biz.crm.kms.business.reconciliation.manage.sdk.dto.InvoiceMessageDto;
import com.biz.crm.kms.business.reconciliation.manage.sdk.dto.KmsReconciliationLogEventDto;
import com.biz.crm.kms.business.reconciliation.manage.sdk.dto.ReconciliationDto;
import com.biz.crm.kms.business.reconciliation.manage.sdk.enums.ReconciliationReturnStatusEnum;
import com.biz.crm.kms.business.reconciliation.manage.sdk.enums.ReconciliationTicketStatusEnum;
import com.biz.crm.kms.business.reconciliation.manage.sdk.listener.ActivityContractCodeListener;
import com.biz.crm.kms.business.reconciliation.manage.sdk.listener.KmsReconciliationLogEventListener;
import com.biz.crm.kms.business.reconciliation.manage.sdk.service.ReconciliationService;
import com.biz.crm.kms.business.reconciliation.manage.sdk.vo.ActivityContractResponse;
import com.biz.crm.kms.business.reconciliation.manage.sdk.vo.InvoiceMessageVo;
import com.biz.crm.kms.business.reconciliation.manage.sdk.vo.ReconciliationVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="reconciliationService")
public class ReconciliationServiceImpl
implements ReconciliationService {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationServiceImpl.class);
    @Autowired(required=false)
    private ReconciliationRepository reconciliationRepository;
    @Autowired(required=false)
    private InvoiceMessageService invoiceMessageService;
    @Autowired(required=false)
    private BackToArticleService backToArticleService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DiscrepancyFeeService discrepancyFeeService;
    @Autowired(required=false)
    private InvoiceStatementVoService invoiceStatementVoService;
    @Autowired(required=false)
    private AuditService auditService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private ReconciliationTransService reconciliationTransService;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;

    public void deleteByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"\u8bf7\u9009\u62e9\u6570\u636e!", (Object[])new Object[0]);
        List<ReconciliationEntity> entities = this.reconciliationRepository.findByIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(entities), (String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664!", (Object[])new Object[0]);
        for (ReconciliationEntity entity : entities) {
            KmsReconciliationLogEventDto logEventDto = new KmsReconciliationLogEventDto();
            ReconciliationDto dto = (ReconciliationDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, ReconciliationDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            logEventDto.setOriginal(dto);
            entity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            dto.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            logEventDto.setNewest(dto);
            SerializableBiConsumer & Serializable onDelete = KmsReconciliationLogEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, KmsReconciliationLogEventListener.class, (SerializableBiConsumer)onDelete);
        }
        this.reconciliationTransService.updateDataList(entities);
    }

    public ReconciliationVo findById(String id) {
        ReconciliationVo vo = this.reconciliationRepository.findById(id);
        if (CollectionUtils.isNotEmpty((Collection)vo.getInvoiceMessageVoList())) {
            List invoiceMessageVoList = vo.getInvoiceMessageVoList();
            BigDecimal amount = invoiceMessageVoList.stream().map(InvoiceMessageVo::getInvoiceAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            for (InvoiceMessageVo invoiceMessageVo : invoiceMessageVoList) {
                invoiceMessageVo.setAllInvoiceAmount(amount);
            }
        }
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(ReconciliationDto dto) {
        BigDecimal decimal;
        this.updateValidate(dto);
        ReconciliationEntity reconciliationEntity = (ReconciliationEntity)((Object)this.reconciliationRepository.getById((Serializable)((Object)dto.getId())));
        ReconciliationDto oldDto = (ReconciliationDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)reconciliationEntity, ReconciliationDto.class, HashSet.class, ArrayList.class, new String[0]);
        Validate.notNull((Object)((Object)reconciliationEntity), (String)"\u672a\u67e5\u8be2\u5230\u88ab\u7f16\u8f91\u7684\u5bf9\u8d26\u5355\u6570\u636e\uff01", (Object[])new Object[0]);
        List invoiceMessageDtoList = dto.getInvoiceMessageDtoList();
        SimpleDateFormat dft = new SimpleDateFormat("yyyy-MM-dd");
        if (CollectionUtils.isNotEmpty((Collection)invoiceMessageDtoList)) {
            this.dataVerification(invoiceMessageDtoList);
            decimal = BigDecimal.ZERO;
            LinkedList<Date> lds = new LinkedList<Date>();
            for (InvoiceMessageDto invoiceMessageDto : invoiceMessageDtoList) {
                BigDecimal invoiceAmount = invoiceMessageDto.getInvoiceAmount();
                decimal = decimal.add(invoiceAmount).setScale(4, 4);
                String invoiceEndDate = invoiceMessageDto.getInvoiceEndDate();
                Validate.notBlank((CharSequence)invoiceEndDate, (String)"\u7968\u5230\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
                try {
                    lds.add(dft.parse(invoiceEndDate));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            if (reconciliationEntity.getTicketAmount().compareTo(decimal) < 0) {
                throw new IllegalArgumentException("\u5f00\u7968\u91d1\u989d\u603b\u6570\u4e0d\u80fd\u5927\u4e8e\u53d1\u7968\u91d1\u989d!");
            }
            dto.setAllTicketAmount(decimal);
            dto.setAlreadyTicketAmount(decimal);
            BigDecimal ticketAmount = reconciliationEntity.getTicketAmount();
            if (BigDecimal.ZERO.compareTo(decimal) != 0 && ticketAmount.compareTo(decimal) > 0) {
                dto.setTicketStatus(ReconciliationTicketStatusEnum.PARTIALINVOICE.getDictCode());
            } else if (ticketAmount.compareTo(decimal) == 0) {
                dto.setTicketStatus(ReconciliationTicketStatusEnum.IVOICED.getDictCode());
            }
            Date maxDate = (Date)Collections.max(lds);
            dto.setTicketToDate(dft.format(maxDate));
            this.invoiceMessageService.createInvoiceMessage(invoiceMessageDtoList);
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getBackToArticleDtoList())) {
            if ("ticket".equals(dto.getAccountType())) {
                Integer unReturnDay = this.getUnReturnDay(dto, dft);
                dto.setUnReturnDay(unReturnDay);
                String accountPeriod = dto.getAccountPeriod();
                if (StringUtils.isNotEmpty((CharSequence)accountPeriod)) {
                    int i = unReturnDay - Integer.parseInt(accountPeriod);
                    if (i > 0) {
                        dto.setAccountPeriodStatus("\u8d85\u8d26\u671f" + i + "\u5929");
                    } else {
                        dto.setAccountPeriodStatus("\u672a\u8d85\u5e10\u671f");
                    }
                }
            }
            decimal = BigDecimal.ZERO;
            BigDecimal alreadyTicketAmount = dto.getAlreadyTicketAmount();
            for (BackToArticleDto backToArticleDto : dto.getBackToArticleDtoList()) {
                BigDecimal returnAmount = backToArticleDto.getCurrentCreditAmount() == null ? BigDecimal.ZERO : backToArticleDto.getCurrentCreditAmount();
                decimal = decimal.add(returnAmount).setScale(4, 4).abs();
            }
            if (alreadyTicketAmount.compareTo(decimal) < 0) {
                throw new IllegalArgumentException("\u56de\u6b3e\u91d1\u989d\u603b\u6570\u4e0d\u80fd\u5927\u4e8e\u5f00\u7968\u91d1\u989d!");
            }
            if (BigDecimal.ZERO.compareTo(decimal) != 0 && alreadyTicketAmount.compareTo(decimal) > 0) {
                dto.setReturnStatus(ReconciliationReturnStatusEnum.PARTIALRETURN.getDictCode());
            } else if (alreadyTicketAmount.compareTo(decimal) == 0) {
                dto.setTicketStatus(ReconciliationReturnStatusEnum.RETURN.getDictCode());
            }
            dto.setActualReturn(decimal.abs());
            this.backToArticleService.createBackToArticle(dto.getBackToArticleDtoList());
        }
        this.updateLog(dto, oldDto);
        ReconciliationEntity entity = (ReconciliationEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, ReconciliationEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.reconciliationRepository.updateById((Object)entity);
    }

    private void dataVerification(List<InvoiceMessageDto> invoiceMessageDtoList) {
        Map collect = invoiceMessageDtoList.stream().collect(Collectors.groupingBy(Function.identity()));
        for (Map.Entry entry : collect.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            throw new RuntimeException("\u53d1\u7968\u53f7\u4e3a" + ((InvoiceMessageDto)entry.getValue().get(0)).getInvoiceNumber() + "\u7684\u6570\u636e\u91cd\u590d");
        }
    }

    private void updateLog(ReconciliationDto dto, ReconciliationDto oldDto) {
        KmsReconciliationLogEventDto logEventDto = new KmsReconciliationLogEventDto();
        logEventDto.setOriginal(oldDto);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onUpdate = KmsReconciliationLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, KmsReconciliationLogEventListener.class, (SerializableBiConsumer)onUpdate);
    }

    private Integer getDay(Date star) {
        Long starTime = star.getTime();
        Long endTime = System.currentTimeMillis();
        Integer unReturnDay = (int)((endTime - starTime) / 86400000L);
        return unReturnDay;
    }

    private Integer getUnReturnDay(ReconciliationDto dto, DateFormat dft) {
        try {
            Date star = dft.parse(dto.getTicketToDate());
            Date endDay = dft.parse(dto.getReconciliationDate());
            Long starTime = star.getTime();
            Long endTime = endDay.getTime();
            Integer unReturnDay = (int)((endTime - starTime) / 86400000L);
            return unReturnDay;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void addOrUpdateRemark(String id, String remark) {
        ReconciliationEntity entity = (ReconciliationEntity)((Object)this.reconciliationRepository.getById((Serializable)((Object)id)));
        entity.setRemark(remark);
        this.reconciliationRepository.saveOrUpdate((Object)entity);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveDiscrepancy(ReconciliationDto dto) {
        this.saveValidate(dto);
        ReconciliationEntity reconciliationEntity = (ReconciliationEntity)((Object)this.reconciliationRepository.getById((Serializable)((Object)dto.getId())));
        ReconciliationDto oldDto = (ReconciliationDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)reconciliationEntity, ReconciliationDto.class, HashSet.class, ArrayList.class, new String[0]);
        Validate.notNull((Object)((Object)reconciliationEntity), (String)"\u56de\u6b3e\u5dee\u5f02\u5904\u7406\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u5bf9\u8d26\u5355\u6570\u636e\uff01", (Object[])new Object[0]);
        List invoiceMessageDtoList = dto.getInvoiceMessageDtoList();
        if (CollectionUtils.isNotEmpty((Collection)invoiceMessageDtoList)) {
            this.dataVerification(invoiceMessageDtoList);
            this.invoiceMessageService.createInvoiceMessage(dto.getInvoiceMessageDtoList());
        }
        BigDecimal current = BigDecimal.ZERO;
        List backToArticleDtoList = dto.getBackToArticleDtoList();
        if (CollectionUtils.isNotEmpty((Collection)backToArticleDtoList)) {
            this.backToArticleService.createBackToArticle(backToArticleDtoList);
            BigDecimal actualReturn = BigDecimal.ZERO;
            BigDecimal reimbursementAmount = BigDecimal.ZERO;
            for (BackToArticleDto backToArticleDto : backToArticleDtoList) {
                current = current.add(backToArticleDto.getCurrentCreditAmount()).setScale(4, 4);
                if ("\u62a5\u9500".equals(backToArticleDto.getReturnType())) {
                    reimbursementAmount = reimbursementAmount.add(backToArticleDto.getReturnAmount()).setScale(4, 4);
                    continue;
                }
                actualReturn = actualReturn.add(backToArticleDto.getReturnAmount()).setScale(4, 4);
            }
            dto.setReimbursementAmount(reimbursementAmount);
            dto.setActualReturn(actualReturn);
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getDiscrepancyFeeDtoList())) {
            Validate.notNull((Object)dto.getDifferFee(), (String)"\u5dee\u5f02\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Validate.notNull((Object)dto.getDiscrepancyFee(), (String)"\u5dee\u5f02\u8d39\u7528\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Validate.notNull((Object)dto.getTemporaryAmount(), (String)"\u6682\u6263\u6b3e\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            this.discrepancyFeeService.createDiscrepancyFee(dto.getDiscrepancyFeeDtoList());
        }
        BigDecimal statementAmount = dto.getStatementAmount();
        BigDecimal alreadyReturnAmount = dto.getAlreadyReturnAmount();
        BigDecimal occupiedExposure = BigDecimal.ZERO;
        if (Objects.nonNull(statementAmount) && Objects.nonNull(alreadyReturnAmount) && statementAmount.compareTo(alreadyReturnAmount) == 1) {
            occupiedExposure = statementAmount.subtract(alreadyReturnAmount).setScale(4, 4);
            dto.setOccupiedExposure(occupiedExposure);
        }
        if (Objects.nonNull(current)) {
            BigDecimal subtract = current.subtract(occupiedExposure).setScale(4, 4);
            dto.setExposureBalance(subtract);
        }
        this.updateLog(dto, oldDto);
        ReconciliationEntity entity = (ReconciliationEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, ReconciliationEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.reconciliationRepository.updateById((Object)entity);
    }

    public void synchronize(String date) {
    }

    public List<String> findSoldPartyCodes() {
        return this.reconciliationRepository.findSoldPartyCodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DynamicTaskService(cornExpression="0 0 23 * * ?", taskDesc="\u6bcf\u592923\u70b9\u70b9\u5b9a\u65f6\u751f\u6210\u7ed3\u7b97\u5355\u6570\u636e")
    public void synchronize() {
        this.loginUserService.refreshAuthentication(null);
        AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
        boolean lock = true;
        String lockKey = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        try {
            lock = this.lock(lockKey);
            if (!lock) {
                return;
            }
            List dataList = this.dictDataVoService.findByDictTypeCode("kms_dzqj");
            String nowDate = DateUtil.date_yyyy_MM_dd.format(new Date()).substring(8, 10);
            if (CollectionUtils.isEmpty(dataList = dataList.stream().filter(vo -> StringUtils.equals((CharSequence)nowDate, (CharSequence)vo.getExt1())).collect(Collectors.toList()))) {
                return;
            }
            String beginDateStr = DateUtil.date_yyyy_MM_dd.format(DateUtil.getFirstDayOfLastMonth());
            String endDateStr = DateUtil.date_yyyy_MM_dd.format(new Date());
            List list = this.invoiceStatementVoService.findAllByConditions(BusinessUnitEnum.SON_COMPANY.getCode(), beginDateStr, endDateStr);
            if (CollectionUtils.isEmpty((Collection)list)) {
                return;
            }
            Map<String, List<InvoiceStatementDataVo>> invoiceStatementMap = list.stream().collect(Collectors.groupingBy(InvoiceStatementDataVo::getDirectCode));
            for (DictDataVo dictDataVo : dataList) {
                if (dictDataVo.getExt2().compareTo(dictDataVo.getExt3()) <= 0) {
                    String beginDate = DateUtil.date_yyyy_MM.format(new Date()) + "-" + dictDataVo.getExt2();
                    String endDate = DateUtil.date_yyyy_MM.format(new Date()) + "-" + dictDataVo.getExt3();
                    String dictValue = dictDataVo.getDictValue();
                    List directCodes = Arrays.stream(dictValue.split("/")).collect(Collectors.toList());
                    for (String directCode : directCodes) {
                        List<Object> invoiceStatementDataVos = invoiceStatementMap.get(directCode);
                        if (CollectionUtils.isEmpty(invoiceStatementDataVos) || CollectionUtils.isEmpty(invoiceStatementDataVos = invoiceStatementDataVos.stream().filter(vo -> beginDate.compareTo(vo.getStatementCode()) >= 0 && endDate.compareTo(vo.getStatementCode()) <= 0).collect(Collectors.toList()))) continue;
                        Set<ReconciliationEntity> reconciliationEntities = this.dataTransformation(invoiceStatementDataVos);
                        this.saveSynchronize(reconciliationEntities);
                    }
                }
                if (dictDataVo.getExt2().compareTo(dictDataVo.getExt3()) < 0) continue;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date());
                calendar.add(2, -1);
                String beginDate = DateUtil.date_yyyy_MM.format(calendar.getTime()) + "-" + dictDataVo.getExt3();
                String endDate = DateUtil.date_yyyy_MM.format(new Date()) + "-" + dictDataVo.getExt2();
                String dictValue = dictDataVo.getDictValue();
                List directCodes = Arrays.stream(dictValue.split("/")).collect(Collectors.toList());
                for (String directCode : directCodes) {
                    List<Object> invoiceStatementDataVos = invoiceStatementMap.get(directCode);
                    if (CollectionUtils.isEmpty(invoiceStatementDataVos) || CollectionUtils.isEmpty(invoiceStatementDataVos = invoiceStatementDataVos.stream().filter(vo -> beginDate.compareTo(vo.getStatementDate()) <= 0 && endDate.compareTo(vo.getStatementDate()) >= 0).collect(Collectors.toList()))) continue;
                    Set<ReconciliationEntity> reconciliationEntities = this.dataTransformation(invoiceStatementDataVos);
                    this.saveSynchronize(reconciliationEntities);
                }
            }
        }
        finally {
            if (lock) {
                this.unLock(lockKey);
            }
        }
    }

    private Set<ReconciliationEntity> dataTransformation(List<InvoiceStatementDataVo> list) {
        HashSet<ReconciliationEntity> reconciliations = new HashSet<ReconciliationEntity>();
        String tenantCode = TenantUtils.getTenantCode();
        String todayStr = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        List soldPartyCodes = list.stream().map(InvoiceStatementDataVo::getSoldToPartyCode).distinct().collect(Collectors.toList());
        String beginDate = DateUtil.format((Date)DateUtil.getFirstDayOfMonth((Date)new Date()), (String)"yyyy-MM-dd");
        String endDate = DateUtil.format((Date)DateUtil.getLastDayOfMonth((Date)new Date()), (String)"yyyy-MM-dd");
        PageRequest pageable = PageRequest.of((int)1, (int)1000);
        Page auditMatchByPage = this.auditService.findAuditByPage((Pageable)pageable, soldPartyCodes, beginDate, endDate);
        ArrayList auditVoList = new ArrayList();
        auditVoList.addAll(auditMatchByPage.getRecords());
        while (auditMatchByPage.hasNext() && 2000 >= pageable.getPageNumber()) {
            pageable = pageable.next();
            auditMatchByPage = this.auditService.findAuditByPage((Pageable)pageable, soldPartyCodes, beginDate, endDate);
            auditVoList.addAll(auditMatchByPage.getRecords());
        }
        Map<Object, Object> matchVoMap = new HashMap();
        if (CollectionUtils.isNotEmpty(auditVoList)) {
            matchVoMap = auditVoList.stream().distinct().collect(Collectors.groupingBy(AuditVo::getSoldToPartyCode));
        }
        for (InvoiceStatementDataVo invoiceStatementDataVo : list) {
            List auditVos;
            ReconciliationEntity reconciliation = (ReconciliationEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)invoiceStatementDataVo, ReconciliationEntity.class, HashSet.class, ArrayList.class, new String[0]));
            reconciliation.setTenantCode(tenantCode);
            reconciliation.setReconciliationDate(todayStr);
            BigDecimal ticketDeductionAmount = invoiceStatementDataVo.getKaTotalAmount() == null ? BigDecimal.ZERO : invoiceStatementDataVo.getKaTotalAmount();
            reconciliation.setKaAmountDeducted(ticketDeductionAmount);
            Map<Object, Object> auditMap = new HashMap();
            if (CollectionUtils.isNotEmpty(auditVoList)) {
                auditMap = auditVoList.stream().collect(Collectors.groupingBy(AuditVo::getSoldToPartyCode));
            }
            if (CollectionUtils.isNotEmpty((Collection)(auditVos = (List)auditMap.get(invoiceStatementDataVo.getSoldToPartyCode())))) {
                BigDecimal sapTotalAmount = BigDecimal.ZERO;
                for (AuditVo auditVo : auditVos) {
                    sapTotalAmount = sapTotalAmount.add(auditVo.getSapTotalAmount());
                }
                reconciliation.setReconciledAmount(sapTotalAmount);
            } else {
                reconciliation.setReconciledAmount(BigDecimal.ZERO);
            }
            BigDecimal statementAmount = invoiceStatementDataVo.getStatementAmount();
            BigDecimal reconciledAmount = reconciliation.getReconciledAmount();
            boolean statementEmpty = Objects.isNull(statementAmount);
            if (statementEmpty && Objects.nonNull(reconciledAmount)) {
                reconciliation.setDifferAmount(reconciliation.getReconciledAmount());
            } else if (!statementEmpty && Objects.nonNull(reconciledAmount)) {
                BigDecimal differAmount = statementAmount.subtract(reconciledAmount).abs().setScale(4, 4);
                reconciliation.setDifferAmount(differAmount);
            }
            if (!statementEmpty) {
                reconciliation.setTicketAmount(statementAmount.subtract(ticketDeductionAmount).setScale(4, 4));
            } else {
                reconciliation.setTicketAmount(statementAmount);
            }
            reconciliation.setTicketDeductionAmount(invoiceStatementDataVo.getTicketDeductionAmount() == null ? BigDecimal.ZERO : invoiceStatementDataVo.getTicketDeductionAmount());
            reconciliation.setAccountDeductionAmount(invoiceStatementDataVo.getAccountDeductionAmount() == null ? BigDecimal.ZERO : invoiceStatementDataVo.getAccountDeductionAmount());
            reconciliation.setTicketStatus(ReconciliationTicketStatusEnum.NOINVOICED.getDictCode());
            reconciliation.setReturnStatus(ReconciliationReturnStatusEnum.NORETURN.getDictCode());
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(invoiceStatementDataVo.getSoldToPartyCode());
            ActivityContractEventDto activityContractEventDto = new ActivityContractEventDto();
            activityContractEventDto.setCusCodeList(arrayList);
            activityContractEventDto.setKaCode(invoiceStatementDataVo.getKaCode());
            activityContractEventDto.setKaName(invoiceStatementDataVo.getKaName());
            SerializableBiConsumer & Serializable sf = ActivityContractCodeListener::findByConditions;
            ActivityContractResponse activityContractVo = (ActivityContractResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)activityContractEventDto, ActivityContractCodeListener.class, (SerializableBiConsumer)sf);
            if (Objects.nonNull(activityContractVo)) {
                InvoiceStatementDataVo statementDataVo;
                String paymentDaysType = activityContractVo.getAccountType();
                String paymentDays = activityContractVo.getAccountPeriod();
                reconciliation.setAccountType(paymentDaysType);
                reconciliation.setAccountPeriod(paymentDays);
                if ("goods".equals(paymentDaysType) && Objects.nonNull(statementDataVo = this.invoiceStatementVoService.findByStatementCode(invoiceStatementDataVo.getStatementCode()))) {
                    Integer unReturnDay = this.getDay(statementDataVo.getAcceptanceTime());
                    reconciliation.setUnReturnDay(unReturnDay);
                    int i = unReturnDay - Integer.parseInt(paymentDays);
                    if (i > 0) {
                        reconciliation.setAccountPeriodStatus("\u8d85\u8d26\u671f" + i + "\u5929");
                    } else {
                        reconciliation.setAccountPeriodStatus("\u672a\u8d85\u5e10\u671f");
                    }
                }
            }
            reconciliation.setAlreadyTicketAmount(BigDecimal.ZERO);
            reconciliation.setAllTicketAmount(BigDecimal.ZERO);
            reconciliation.setActualReturn(BigDecimal.ZERO);
            reconciliation.setReimbursementAmount(BigDecimal.ZERO);
            reconciliation.setTemporaryAmount(BigDecimal.ZERO);
            reconciliation.setDifferFee(reconciliation.getTicketAmount().subtract(reconciliation.getActualReturn()).setScale(4, 4));
            reconciliation.setOccupiedExposure(reconciliation.getTicketAmount().subtract(reconciliation.getActualReturn()).subtract(reconciliation.getReimbursementAmount()));
            reconciliations.add(reconciliation);
        }
        return reconciliations;
    }

    public void saveSynchronize(Set<ReconciliationEntity> reconciliations) {
        if (CollectionUtils.isEmpty(reconciliations)) {
            return;
        }
        reconciliations.forEach(reconciliationEntity -> {
            ReconciliationDto dto = (ReconciliationDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)reconciliationEntity, ReconciliationDto.class, HashSet.class, ArrayList.class, new String[0]);
            KmsReconciliationLogEventDto logEventDto = new KmsReconciliationLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer & Serializable onCreate = KmsReconciliationLogEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, KmsReconciliationLogEventListener.class, (SerializableBiConsumer)onCreate);
        });
        this.reconciliationTransService.saveDataList(reconciliations);
    }

    public ReconciliationVo findOneByConditions(ExposureConditionsDto dto) {
        Validate.notNull((Object)dto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)dto.getSoldToPartyCode()) && StringUtils.isBlank((CharSequence)dto.getSoldToPartyName())) {
            return null;
        }
        return this.reconciliationRepository.findOneByConditions(dto);
    }

    private void unLock(String lockKey) {
        if (StringUtils.isEmpty((CharSequence)lockKey)) {
            throw new RuntimeException("\u62c9\u53d6\u5e93\u5b58\u6570\u636e\u89e3\u9501\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.redisMutexService.unlock("reconciliation_report_lock:lock:" + lockKey);
    }

    private boolean lock(String lockKey) {
        if (StringUtils.isEmpty((CharSequence)lockKey)) {
            throw new RuntimeException("\u62c9\u53d6\u5e93\u5b58\u6570\u636e\u52a0\u9501\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.redisMutexService.tryLock("reconciliation_report_lock:lock:" + lockKey, TimeUnit.HOURS, 12);
    }

    public Page<ReconciliationVo> findByConditions(Pageable pageable, ReconciliationDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new ReconciliationDto();
        }
        return this.reconciliationRepository.findByConditions(pageable, dto);
    }

    private void updateValidate(ReconciliationDto dto) {
        Validate.notNull((Object)dto, (String)"\u7f16\u8f91\u7684\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getId(), (String)"\u5bf9\u8d26\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
    }

    private void saveValidate(ReconciliationDto dto) {
        Validate.notNull((Object)dto, (String)"\u56de\u6b3e\u5dee\u5f02\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getId(), (String)"\u5bf9\u8d26\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    }
}

