/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.reconciliation.manage.local.task.impl;

import com.biz.crm.kms.business.reconciliation.manage.local.service.Zmfi046Service;
import com.biz.crm.kms.business.reconciliation.manage.local.task.PullZmfi046Task;
import com.biz.crm.mn.third.system.dataphin.sdk.DataphinService;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PullZmfi046TaskImpl
implements PullZmfi046Task {
    private static final Logger log = LoggerFactory.getLogger(PullZmfi046TaskImpl.class);
    @Autowired
    private DataphinService dataphinService;
    @Autowired
    private Zmfi046Service zmfi046Service;
    private String size = "2000";

    @Override
    @Transactional
    public void timedTaskLastMonthData() {
        Date date = new Date();
        long startTime = date.getTime();
        log.info("----> {}\u6267\u884c\u5b9a\u65f6\u4efb\u52a1 <----", (Object)this.getDateAndTime("dateTime"));
        log.info("----> {} \u6267\u884c\u5b9a\u65f6\u4efb\u52a1 <----", (Object)this.getDateAndTime("dateTime"));
        this.pullLastMonthData();
        log.info("----> {} \u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5 <----", (Object)this.getDateAndTime("dateTime"));
        long endTime = date.getTime();
        int minutes = (int)((endTime - startTime) / 60000L);
        log.info("\u603b\u5171\u8017\u65f6 {} \u5206\u949f", (Object)minutes);
    }

    private void pullLastMonthData() {
        LocalDate now = LocalDate.now();
        String ds = now.format(DateTimeFormatter.ofPattern("yyyyMM")) + "01";
        Integer total = this.dataphinService.getZmfi046Total(ds);
        Integer size = Integer.valueOf(this.size);
        this.zmfi046Service.delEmtityBatch(ds);
        total = total / 9;
        Integer page = total / size;
        page = total % size == 0 ? page : page + 1;
        log.info("\u5171{}\u6761\u6570\u636e, \u9700\u8c03\u7528{}\u6b21, \u6bcf\u6b21\u83b7\u53d6{}\u6761\u6570\u636e", new Object[]{total, page, size});
        for (int i = 1; i <= page; ++i) {
            List zmfi046Vos = this.dataphinService.getZmfi046(ds, Integer.valueOf(i), size);
            this.zmfi046Service.saveEmtityBatch(zmfi046Vos);
            log.info("\u7b2c{} \u6279\u6570\u636e\u4fdd\u5b58\u6210\u529f\uff01", (Object)i);
        }
    }

    private String getDateAndTime(String flag) {
        if ("TheDayBefore".equals(flag)) {
            LocalDate localDate = LocalDate.now().minusDays(1L);
            return localDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        }
        if ("TheMonthBefore".equals(flag)) {
            LocalDate localDate = LocalDate.now().minusMonths(1L);
            return localDate.getYear() + String.valueOf(localDate.getMonthValue());
        }
        if ("TheYearBefore".equals(flag)) {
            LocalDate localDate = LocalDate.now().minusYears(1L);
            return String.valueOf(localDate.getYear());
        }
        if ("year".equals(flag)) {
            LocalDate localDate = LocalDate.now();
            return String.valueOf(localDate.getYear());
        }
        if ("monthNumber".equals(flag)) {
            LocalDate localDate = LocalDate.now();
            return String.valueOf(localDate.getMonthValue());
        }
        if ("month".equals(flag)) {
            LocalDate localDate = LocalDate.now();
            return localDate.getYear() + String.valueOf(localDate.getMonth());
        }
        Date date = new Date();
        if ("dateTime".equals(flag)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return format.format(date);
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return format.format(date);
    }
}

