package com.biz.crm.kms.business.reconciliation.manage.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author hd
 * @version 1.0
 * @date 2022/12/10 9:19
 * @description BackToArticleDto
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "回款信息dto")
public class BackToArticleDto extends TenantFlagOpDto {
    @ApiModelProperty("售达方名称")
    private String soldToPartyName;

    @ApiModelProperty("售达方编码")
    private String soldToPartyCode;

    @ApiModelProperty("开始时间")
    private String accountStartDate;

    @ApiModelProperty("结束时间")
    private String accountEndDate;

    @ApiModelProperty("过账时间")
    private String postingDate;

    @ApiModelProperty("凭证类型")
    private String voucherType;

    @ApiModelProperty("凭证抬头文本")
    private String voucherTitleText;

    @ApiModelProperty("本期贷方发生额")
    private BigDecimal currentCreditAmount;

    @ApiModelProperty("凭证编号")
    private String voucherCode;

    @ApiModelProperty("回款单位")
    private String returnUnit;

    @ApiModelProperty("回款类型")
    private String returnType;

    @ApiModelProperty("回款金额")
    private BigDecimal returnAmount;

    @ApiModelProperty("回款日期")
    private String returnDate;

    @ApiModelProperty("关联id")
    private String relationId;

}
