package com.biz.crm.kms.business.reconciliation.manage.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author hd
 * @version 1.0
 * @date 2022/12/10 14:19
 * @description DiscrepancyFeeDto
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "KMS-差异费用dto")
public class DiscrepancyFeeDto extends TenantFlagOpDto {
    /**
     * 活动细案编码
     */
    @ApiModelProperty("活动细案编码")
    private String activityDetailCode;
    /**
     * 活动细案明细编码
     */
    @ApiModelProperty("活动细案明细编码")
    private String activityDetailItemCode;
    /**
     * 申请金额
     */
    @ApiModelProperty("申请金额")
    private BigDecimal feeAmount;
    /**
     * 核销金额
     */
    @ApiModelProperty("核销金额")
    private BigDecimal alreadyAuditAmount;
    /**
     * 门店编码
     */
    @ApiModelProperty("门店编码")
    private String terminalCode;
    /**
     * 门店名称
     */
    @ApiModelProperty("门店名称")
    private String terminalName;
    /**
     * 活动开始时间
     */
    @ApiModelProperty("活动开始时间")
    private String activityBeginDate;
    /**
     * 活动结束时间
     */
    @ApiModelProperty("活动结束时间")
    private String activityEndDate;
    /**
     * 关联id
     */
    @ApiModelProperty("关联id")
    private String relationId;

    /**
     * 上账金额
     */
    @ApiModelProperty("上账金额")
    private BigDecimal alreadyUpAccountAmount;
}
