package com.biz.crm.kms.business.reconciliation.manage.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author cyj
 * @version 1.0
 * @date 2022/12/9 17:38
 * @description InvoiceMessageDto
 */
@Data
@ApiModel(value = "InvoiceMessageDto", description = "发票信息Dto")
public class InvoiceMessageDto extends TenantFlagOpDto {

    @ApiModelProperty("序号")
    private String itemIndex;

    @ApiModelProperty("发票号")
    private String invoiceNumber;

    @ApiModelProperty("开票单位")
    private String invoiceCompany;

    @ApiModelProperty("开票时间")
    private String invoiceStartDate;

    @ApiModelProperty("票到时间")
    private String invoiceEndDate;

    @ApiModelProperty("开票金额")
    private BigDecimal invoiceAmount;

    @ApiModelProperty("关联id")
    private String relationId;
}
