package com.biz.crm.kms.business.reconciliation.manage.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author cyj
 * @version 1.0
 * @date 2022/12/9 17:54
 * @description ReconciliationDto
 */
@Data
@ApiModel(value = "reconciliationDto", description = "对账单信息Dto")
public class ReconciliationDto extends TenantFlagOpDto {

    @ApiModelProperty("对账单时间")
    private String reconciliationDate;

    @ApiModelProperty("账期类型")
    private String accountType;

    @ApiModelProperty("账期")
    private String accountPeriod;

    @ApiModelProperty("零售商名称")
    private String kaName;

    @ApiModelProperty("零售商编码")
    private String kaCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]", notes = "")
    private String businessFormatCode;

    /**
     * 业务单元
     */
    @ApiModelProperty(name = "业务单元", notes = "")
    private String businessUnitCode;

    @ApiModelProperty("售达方名称")
    private String soldToPartyName;

    @ApiModelProperty("售达方编码")
    private String soldToPartyCode;

    /**
     * 对账金额
     */
    @ApiModelProperty("对账金额")
    private BigDecimal reconciledAmount;

    /**
     * 差异金额(对账和结算金额的差异金额)
     */
    @ApiModelProperty("差异金额")
    private BigDecimal differAmount;

    /**
     * 关联结算单号
     */
    @ApiModelProperty("关联结算单号")
    private String statementCode;

    /**
     * 关联结算日期
     */
    @ApiModelProperty("关联结算单日期")
    private String statementDate;

    @ApiModelProperty("零售商扣费总金额")
    private BigDecimal kaAmountDeducted;

    @ApiModelProperty("票扣费用")
    private BigDecimal ticketDeductionAmount;

    @ApiModelProperty("账扣费用")
    private BigDecimal accountDeductionAmount;

    @ApiModelProperty("开票金额")
    private BigDecimal ticketAmount;

    @ApiModelProperty("开票状态")
    private String ticketStatus;

    @ApiModelProperty("票到时间")
    private String ticketToDate;

    @ApiModelProperty("已开票金额")
    private BigDecimal alreadyTicketAmount;

    @ApiModelProperty("开票总金额")
    private BigDecimal allTicketAmount;
    @ApiModelProperty("已回款金额")
    private BigDecimal alreadyReturnAmount;

    @ApiModelProperty("回款状态")
    private String returnStatus;

    @ApiModelProperty("实际回款")
    private BigDecimal actualReturn;

    @ApiModelProperty("报销费用")
    private BigDecimal reimbursementAmount;

    /**
     * 差异金额=开票金额-已匹配回款金额
     */
    @ApiModelProperty("差异金额")
    private BigDecimal differFee;
    /**
     * 差异费用(差异费用=差异金额-暂扣款)
     */
    @ApiModelProperty("差异费用(差异费用=差异金额-暂扣款)")
    private BigDecimal discrepancyFee;

    @ApiModelProperty("暂扣款")
    private BigDecimal temporaryAmount;

    @ApiModelProperty("未回款天数")
    private Integer unReturnDay;

    @ApiModelProperty("账期状态")
    private String accountPeriodStatus;

    @ApiModelProperty("已占用敞口")
    private BigDecimal occupiedExposure;

    @ApiModelProperty("敞口余额")
    private BigDecimal exposureBalance;
    /**
     * 开票信息
     */
    @ApiModelProperty("开票信息")
    private List<InvoiceMessageDto> invoiceMessageDtoList;
    /**
     * 回款信息
     */
    @ApiModelProperty("回款信息")
    private List<BackToArticleDto> backToArticleDtoList;
    /**
     * 差异费用信息
     */
    @ApiModelProperty("差异费用信息")
    private List<DiscrepancyFeeDto> discrepancyFeeDtoList;
    /**
     * 结算金额
     */
    @ApiModelProperty("结算金额")
    private BigDecimal statementAmount;

    /**
     * 单据开始日期
     */
    @ApiModelProperty("单据开始日期")
    private String beginDate;

    /**
     * 单据结束日期
     */
    @ApiModelProperty("单据结束日期")
    private String endDate;
}
