package com.biz.crm.kms.business.reconciliation.manage.sdk.enums;

import lombok.Getter;

/**
 * @author cyj
 * @version 1.0
 * @date 2023/2/21 22:16
 * @description ReconciliationReturnStatusEnum
 */
@Getter
public enum ReconciliationReturnStatusEnum {

    NORETURN("noReturn", "100", "未回款", "1"),
    RETURN("return","200","已回款","2"),
    PARTIALRETURN("partialReturn","101","部分回款","3");
    private String key;
    /**
     * 字典编码
     */
    private String dictCode;
    /**
     * 字典值
     */
    private String value;
    /**
     * 字典排序
     */
    private String order;

    ReconciliationReturnStatusEnum(String key, String dictCode, String value, String order) {
        this.key = key;
        this.dictCode = dictCode;
        this.order = order;
        this.value = value;
    }

    /**
     * 通过字典编码获取枚举值
     *
     * @param dictCode 字典编码
     * @return 取枚举值
     */
    public static ReconciliationReturnStatusEnum getByDictCode(String dictCode) {
        ReconciliationReturnStatusEnum result = null;
        for (ReconciliationReturnStatusEnum type : ReconciliationReturnStatusEnum.values()) {
            if (type.getDictCode().equals(dictCode)) {
                result = type;
                break;
            }
        }
        return result;
    }
}
