package com.biz.crm.kms.business.reconciliation.manage.sdk.enums;

import lombok.Getter;

/**
 * @author cyj
 * @version 1.0
 * @date 2023/2/21 22:05
 * @description ReconciliationTicketStatus
 */
@Getter
public enum ReconciliationTicketStatusEnum {

    NOINVOICED("noInvoice", "100", "未开票", "1"),
    IVOICED("invoiced","200","已开票","2"),
    PARTIALINVOICE("partialInvoice","101","部分开票","3");
    private String key;
    /**
     * 字典编码
     */
    private String dictCode;
    /**
     * 字典值
     */
    private String value;
    /**
     * 字典排序
     */
    private String order;

    ReconciliationTicketStatusEnum(String key, String dictCode, String value, String order) {
        this.key = key;
        this.dictCode = dictCode;
        this.order = order;
        this.value = value;
    }

    /**
     * 通过字典编码获取枚举值
     *
     * @param dictCode 字典编码
     * @return 取枚举值
     */
    public static ReconciliationTicketStatusEnum getByDictCode(String dictCode) {
        ReconciliationTicketStatusEnum result = null;
        for (ReconciliationTicketStatusEnum type : ReconciliationTicketStatusEnum.values()) {
            if (type.getDictCode().equals(dictCode)) {
                result = type;
                break;
            }
        }
        return result;
    }
}
