package com.biz.crm.kms.business.reconciliation.manage.sdk.listener;


import com.biz.crm.kms.business.reconciliation.manage.sdk.dto.KmsReconciliationLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * 业务日志事件接口
 *
 * @author hd
 * @create 2022-11-04 16:51
 */
public interface KmsReconciliationLogEventListener extends NebulaEvent {

    /**
     * 创建事件
     *
     * @param dto
     * @author hd
     * @date 2023/01/03 18:10
     **/
    void onCreate(KmsReconciliationLogEventDto dto);

    /**
     * 删除事件
     *
     * @param dto
     * @author hd
     * @date 2023/01/03 18:10
     **/
    void onDelete(KmsReconciliationLogEventDto dto);

    /**
     * 修改事件
     *
     * @param dto
     * @author hd
     * @date 2023/01/03 18:10
     **/
    void onUpdate(KmsReconciliationLogEventDto dto);

    /**
     * 启用事件
     *
     * @param dto
     * @author hd
     * @date 2023/01/03 18:10
     **/
    void onEnable(KmsReconciliationLogEventDto dto);

    /**
     * 禁用事件
     *
     * @param dto
     * @author hd
     * @date 2023/01/03 18:10
     **/
    void onDisable(KmsReconciliationLogEventDto dto);

}
