package com.biz.crm.kms.business.reconciliation.manage.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.business.reconciliation.manage.sdk.dto.ExposureConditionsDto;
import com.biz.crm.kms.business.reconciliation.manage.sdk.dto.ReconciliationDto;
import com.biz.crm.kms.business.reconciliation.manage.sdk.vo.ReconciliationVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 对账单管理(ReconciliationEntity)表服务接口
 *
 * @author makejava
 * @since 2022-12-09 15:30:20
 */
public interface ReconciliationService {
    /**
     * 根据id批量删除
     * @param ids
     */
    void deleteByIds(List<String> ids);


    /**
     * 根据id查对账单明细，带发票信息
     * @param id
     * @return
     */
    ReconciliationVo findById (String id);

    /**
     * 编辑对账单信息
     * @param dto
     */
    void update(ReconciliationDto dto);

    /**
     * 添加或者修改备注
     * @param id
     * @param remark
     */
    void addOrUpdateRemark(String id,String remark);
    /**
     * 保存回款差异处理
     *
     * @param dto 实体对象
     * @return
     */
    void saveDiscrepancy(ReconciliationDto dto);
    /**
     * 同步上月结算单数据
     */
    void synchronize();
    /**
     * 条件查询单条数据
     *
     * @param dto 条件实体对象
     * @return 单条数据
     */
    ReconciliationVo findOneByConditions(ExposureConditionsDto dto);
    /**
     * 分页条件查询数据
     *
     * @param pageable 分页对象
     * @param dto      查询条件实体
     * @return 所有数据
     */
    Page<ReconciliationVo> findByConditions(Pageable pageable, ReconciliationDto dto);
    /**
     * 同步指定时间所在月份结算单数据
     */
    void synchronize(String date);

    /**
     * 查询售达方
     * @return
     */
    List<String> findSoldPartyCodes();
}
