package com.biz.crm.kms.business.reconciliation.manage.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author hd
 * @version 1.0
 * @date 2022/12/9 18:19
 * @description BackToArticleVo
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "KMS-回款信息vo")
public class BackToArticleVo extends TenantFlagOpVo {

    @ApiModelProperty("售达方名称")
    private String soldToPartyName;

    @ApiModelProperty("售达方编码")
    private String soldToPartyCode;

    @ApiModelProperty("时间")
    private String accountDate;

    @ApiModelProperty("过账时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date postingDate;

    @ApiModelProperty("凭证类型")
    private String voucherType;

    @ApiModelProperty("凭证抬头文本")
    private String voucherTitleText;

    @ApiModelProperty("本期贷方发生额")
    private BigDecimal currentCreditAmount;

    @ApiModelProperty("凭证编号")
    private String voucherCode;

    @ApiModelProperty("回款单位")
    private String returnUnit;

    @ApiModelProperty("回款类型")
    private String returnType;

    @ApiModelProperty("回款金额")
    private BigDecimal returnAmount;

    @ApiModelProperty("回款日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date returnDate;

}
