package com.biz.crm.kms.business.reconciliation.manage.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author cyj
 * @version 1.0
 * @date 2022/12/9 16:26
 * @description ReconciliationVo
 */
@Data
public class ReconciliationVo extends TenantFlagOpVo {

    @ApiModelProperty("对账单时间")
    private String reconciliationDate;

    @ApiModelProperty("账期类型")
    private String accountType;

    @ApiModelProperty("账期")
    private String accountPeriod;

    @ApiModelProperty("系统编码")
    private String directCode;

    @ApiModelProperty("零售商名称")
    private String kaName;

    @ApiModelProperty("零售商编码")
    private String kaCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    /**
     * 业务单元
     */
    @ApiModelProperty(name = "业务单元")
    private String businessUnitCode;

    @ApiModelProperty("售达方名称")
    private String soldToPartyName;

    @ApiModelProperty("售达方编码")
    private String soldToPartyCode;

    /**
     * 对账金额
     */
    @ApiModelProperty("对账金额")
    private BigDecimal reconciledAmount;

    /**
     * 差异金额(对账和结算金额的差异金额)
     */
    @ApiModelProperty("差异金额")
    private BigDecimal differAmount;

    /**
     * 关联结算单号
     */
    @ApiModelProperty("关联结算单号")
    private String statementCode;

    /**
     * 关联结算日期
     */
    @ApiModelProperty("关联结算单日期")
    private String statementDate;

    @ApiModelProperty("零售商扣费总金额")
    private BigDecimal kaAmountDeducted;

    @ApiModelProperty("票扣费用")
    private BigDecimal ticketDeductionAmount;

    @ApiModelProperty("账扣费用")
    private BigDecimal accountDeductionAmount;

    @ApiModelProperty("开票金额")
    private BigDecimal ticketAmount;

    @ApiModelProperty("开票状态")
    private String ticketStatus;

    @ApiModelProperty("已开票金额")
    private BigDecimal alreadyTicketAmount;

    @ApiModelProperty("开票总金额")
    private BigDecimal allTicketAmount;

    @ApiModelProperty("已回款金额")
    private BigDecimal alreadyReturnAmount;

    @ApiModelProperty("票到时间")
    private String ticketToDate;

    @ApiModelProperty("回款状态")
    private String returnStatus;

    @ApiModelProperty("实际回款")
    private BigDecimal actualReturn;

    @ApiModelProperty("报销费用")
    private BigDecimal reimbursementAmount;

    /**
     * 差异金额=开票金额-已匹配回款金额
     */
    @ApiModelProperty("差异金额")
    private BigDecimal differFee;

    @ApiModelProperty("暂扣款")
    private BigDecimal temporaryAmount;

    @ApiModelProperty("未回款天数")
    private Integer unReturnDay;

    @ApiModelProperty("账期状态")
    private String accountPeriodStatus;

    @ApiModelProperty("已占用敞口")
    private BigDecimal occupiedExposure;

    @ApiModelProperty("敞口余额")
    private BigDecimal exposureBalance;

    @ApiModelProperty("发票信息")
    private List<InvoiceMessageVo> invoiceMessageVoList;

    @ApiModelProperty("回款信息")
    private List<BackToArticleVo> backToArticleVoList;
    /**
     * 结算金额
     */
    @ApiModelProperty("结算金额")
    private BigDecimal statementAmount;
}
